/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.SubvolumesClient;
import com.azure.resourcemanager.netapp.fluent.models.SubvolumeInfoInner;
import com.azure.resourcemanager.netapp.fluent.models.SubvolumeModelInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.implementation.SubvolumeInfoImpl;
import com.azure.resourcemanager.netapp.implementation.SubvolumeModelImpl;
import com.azure.resourcemanager.netapp.models.SubvolumeInfo;
import com.azure.resourcemanager.netapp.models.SubvolumeModel;
import com.azure.resourcemanager.netapp.models.Subvolumes;

public final class SubvolumesImpl
implements Subvolumes {
    private static final ClientLogger LOGGER = new ClientLogger(SubvolumesImpl.class);
    private final SubvolumesClient innerClient;
    private final NetAppFilesManager serviceManager;

    public SubvolumesImpl(SubvolumesClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SubvolumeInfo> listByVolume(String resourceGroupName, String accountName, String poolName, String volumeName) {
        PagedIterable<SubvolumeInfoInner> inner = this.serviceClient().listByVolume(resourceGroupName, accountName, poolName, volumeName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SubvolumeInfoImpl((SubvolumeInfoInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SubvolumeInfo> listByVolume(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        PagedIterable<SubvolumeInfoInner> inner = this.serviceClient().listByVolume(resourceGroupName, accountName, poolName, volumeName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SubvolumeInfoImpl((SubvolumeInfoInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<SubvolumeInfo> getWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String subvolumeName, Context context) {
        Response<SubvolumeInfoInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, poolName, volumeName, subvolumeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SubvolumeInfoImpl((SubvolumeInfoInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SubvolumeInfo get(String resourceGroupName, String accountName, String poolName, String volumeName, String subvolumeName) {
        SubvolumeInfoInner inner = this.serviceClient().get(resourceGroupName, accountName, poolName, volumeName, subvolumeName);
        if (inner != null) {
            return new SubvolumeInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName, String subvolumeName) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, volumeName, subvolumeName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName, String subvolumeName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, volumeName, subvolumeName, context);
    }

    @Override
    public SubvolumeModel getMetadata(String resourceGroupName, String accountName, String poolName, String volumeName, String subvolumeName) {
        SubvolumeModelInner inner = this.serviceClient().getMetadata(resourceGroupName, accountName, poolName, volumeName, subvolumeName);
        if (inner != null) {
            return new SubvolumeModelImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SubvolumeModel getMetadata(String resourceGroupName, String accountName, String poolName, String volumeName, String subvolumeName, Context context) {
        SubvolumeModelInner inner = this.serviceClient().getMetadata(resourceGroupName, accountName, poolName, volumeName, subvolumeName, context);
        if (inner != null) {
            return new SubvolumeModelImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SubvolumeInfo getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        String subvolumeName = ResourceManagerUtils.getValueFromIdByName(id, "subvolumes");
        if (subvolumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'subvolumes'.", id)));
        }
        return (SubvolumeInfo)this.getWithResponse(resourceGroupName, accountName, poolName, volumeName, subvolumeName, Context.NONE).getValue();
    }

    @Override
    public Response<SubvolumeInfo> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        String subvolumeName = ResourceManagerUtils.getValueFromIdByName(id, "subvolumes");
        if (subvolumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'subvolumes'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, poolName, volumeName, subvolumeName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        String subvolumeName = ResourceManagerUtils.getValueFromIdByName(id, "subvolumes");
        if (subvolumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'subvolumes'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, volumeName, subvolumeName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        String subvolumeName = ResourceManagerUtils.getValueFromIdByName(id, "subvolumes");
        if (subvolumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'subvolumes'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, volumeName, subvolumeName, context);
    }

    private SubvolumesClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public SubvolumeInfoImpl define(String name) {
        return new SubvolumeInfoImpl(name, this.manager());
    }
}

