/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.SnapshotPolicyProperties;
import com.azure.resourcemanager.netapp.models.DailySchedule;
import com.azure.resourcemanager.netapp.models.HourlySchedule;
import com.azure.resourcemanager.netapp.models.MonthlySchedule;
import com.azure.resourcemanager.netapp.models.WeeklySchedule;
import java.io.IOException;
import java.util.Map;

public final class SnapshotPolicyInner
extends Resource {
    private String etag;
    private SnapshotPolicyProperties innerProperties = new SnapshotPolicyProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(SnapshotPolicyInner.class);

    public String etag() {
        return this.etag;
    }

    private SnapshotPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public SnapshotPolicyInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public SnapshotPolicyInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public HourlySchedule hourlySchedule() {
        return this.innerProperties() == null ? null : this.innerProperties().hourlySchedule();
    }

    public SnapshotPolicyInner withHourlySchedule(HourlySchedule hourlySchedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotPolicyProperties();
        }
        this.innerProperties().withHourlySchedule(hourlySchedule);
        return this;
    }

    public DailySchedule dailySchedule() {
        return this.innerProperties() == null ? null : this.innerProperties().dailySchedule();
    }

    public SnapshotPolicyInner withDailySchedule(DailySchedule dailySchedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotPolicyProperties();
        }
        this.innerProperties().withDailySchedule(dailySchedule);
        return this;
    }

    public WeeklySchedule weeklySchedule() {
        return this.innerProperties() == null ? null : this.innerProperties().weeklySchedule();
    }

    public SnapshotPolicyInner withWeeklySchedule(WeeklySchedule weeklySchedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotPolicyProperties();
        }
        this.innerProperties().withWeeklySchedule(weeklySchedule);
        return this;
    }

    public MonthlySchedule monthlySchedule() {
        return this.innerProperties() == null ? null : this.innerProperties().monthlySchedule();
    }

    public SnapshotPolicyInner withMonthlySchedule(MonthlySchedule monthlySchedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotPolicyProperties();
        }
        this.innerProperties().withMonthlySchedule(monthlySchedule);
        return this;
    }

    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    public SnapshotPolicyInner withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotPolicyProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model SnapshotPolicyInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SnapshotPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return (SnapshotPolicyInner)((Object)jsonReader.readObject(reader -> {
            SnapshotPolicyInner deserializedSnapshotPolicyInner = new SnapshotPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSnapshotPolicyInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSnapshotPolicyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSnapshotPolicyInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSnapshotPolicyInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSnapshotPolicyInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSnapshotPolicyInner.innerProperties = SnapshotPolicyProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedSnapshotPolicyInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSnapshotPolicyInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSnapshotPolicyInner;
        }));
    }
}

