/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.MirrorState;
import com.azure.resourcemanager.netapp.models.RelationshipStatus;
import java.io.IOException;

public final class BackupStatusInner
implements JsonSerializable<BackupStatusInner> {
    private Boolean healthy;
    private RelationshipStatus relationshipStatus;
    private MirrorState mirrorState;
    private String unhealthyReason;
    private String errorMessage;
    private Long lastTransferSize;
    private String lastTransferType;
    private Long totalTransferBytes;
    private Long transferProgressBytes;

    public Boolean healthy() {
        return this.healthy;
    }

    public RelationshipStatus relationshipStatus() {
        return this.relationshipStatus;
    }

    public MirrorState mirrorState() {
        return this.mirrorState;
    }

    public String unhealthyReason() {
        return this.unhealthyReason;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Long lastTransferSize() {
        return this.lastTransferSize;
    }

    public String lastTransferType() {
        return this.lastTransferType;
    }

    public Long totalTransferBytes() {
        return this.totalTransferBytes;
    }

    public Long transferProgressBytes() {
        return this.transferProgressBytes;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static BackupStatusInner fromJson(JsonReader jsonReader) throws IOException {
        return (BackupStatusInner)jsonReader.readObject(reader -> {
            BackupStatusInner deserializedBackupStatusInner = new BackupStatusInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("healthy".equals(fieldName)) {
                    deserializedBackupStatusInner.healthy = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("relationshipStatus".equals(fieldName)) {
                    deserializedBackupStatusInner.relationshipStatus = RelationshipStatus.fromString(reader.getString());
                    continue;
                }
                if ("mirrorState".equals(fieldName)) {
                    deserializedBackupStatusInner.mirrorState = MirrorState.fromString(reader.getString());
                    continue;
                }
                if ("unhealthyReason".equals(fieldName)) {
                    deserializedBackupStatusInner.unhealthyReason = reader.getString();
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    deserializedBackupStatusInner.errorMessage = reader.getString();
                    continue;
                }
                if ("lastTransferSize".equals(fieldName)) {
                    deserializedBackupStatusInner.lastTransferSize = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("lastTransferType".equals(fieldName)) {
                    deserializedBackupStatusInner.lastTransferType = reader.getString();
                    continue;
                }
                if ("totalTransferBytes".equals(fieldName)) {
                    deserializedBackupStatusInner.totalTransferBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("transferProgressBytes".equals(fieldName)) {
                    deserializedBackupStatusInner.transferProgressBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupStatusInner;
        });
    }
}

