/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.netapp.fluent.SnapshotsClient;
import com.azure.resourcemanager.netapp.fluent.models.SnapshotInner;
import com.azure.resourcemanager.netapp.implementation.NetAppManagementClientImpl;
import com.azure.resourcemanager.netapp.models.SnapshotRestoreFiles;
import com.azure.resourcemanager.netapp.models.SnapshotsList;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class SnapshotsClientImpl
implements SnapshotsClient {
    private final SnapshotsService service;
    private final NetAppManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(SnapshotsClientImpl.class);

    SnapshotsClientImpl(NetAppManagementClientImpl client) {
        this.service = (SnapshotsService)RestProxy.create(SnapshotsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SnapshotInner>> listSinglePageAsync(String resourceGroupName, String accountName, String poolName, String volumeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SnapshotsList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SnapshotInner> listAsync(String resourceGroupName, String accountName, String poolName, String volumeName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, accountName, poolName, volumeName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SnapshotInner> listSinglePage(String resourceGroupName, String accountName, String poolName, String volumeName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SnapshotsList> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SnapshotsList)res.getValue()).value(), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SnapshotInner> listSinglePage(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SnapshotsList> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SnapshotsList)res.getValue()).value(), null, null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SnapshotInner> list(String resourceGroupName, String accountName, String poolName, String volumeName) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, accountName, poolName, volumeName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SnapshotInner> list(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, accountName, poolName, volumeName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SnapshotInner>> getWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (snapshotName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, snapshotName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SnapshotInner> getAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName) {
        return this.getWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, snapshotName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SnapshotInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SnapshotInner> getWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (snapshotName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, snapshotName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SnapshotInner get(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName) {
        return (SnapshotInner)((Object)this.getWithResponse(resourceGroupName, accountName, poolName, volumeName, snapshotName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (snapshotName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, snapshotName, this.client.getApiVersion(), body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotInner body) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (snapshotName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return this.service.createSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, snapshotName, this.client.getApiVersion(), body, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (snapshotName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return this.service.createSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, snapshotName, this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SnapshotInner>, SnapshotInner> beginCreateAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotInner body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, snapshotName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)SnapshotInner.class), (Type)((Object)SnapshotInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SnapshotInner>, SnapshotInner> beginCreate(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotInner body) {
        Response<BinaryData> response = this.createWithResponse(resourceGroupName, accountName, poolName, volumeName, snapshotName, body);
        return this.client.getLroResult(response, (Type)((Object)SnapshotInner.class), (Type)((Object)SnapshotInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SnapshotInner>, SnapshotInner> beginCreate(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotInner body, Context context) {
        Response<BinaryData> response = this.createWithResponse(resourceGroupName, accountName, poolName, volumeName, snapshotName, body, context);
        return this.client.getLroResult(response, (Type)((Object)SnapshotInner.class), (Type)((Object)SnapshotInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SnapshotInner> createAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotInner body) {
        return this.beginCreateAsync(resourceGroupName, accountName, poolName, volumeName, snapshotName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SnapshotInner create(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotInner body) {
        return (SnapshotInner)((Object)this.beginCreate(resourceGroupName, accountName, poolName, volumeName, snapshotName, body).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SnapshotInner create(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotInner body, Context context) {
        return (SnapshotInner)((Object)this.beginCreate(resourceGroupName, accountName, poolName, volumeName, snapshotName, body, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, Object body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (snapshotName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, snapshotName, this.client.getApiVersion(), body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, Object body) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (snapshotName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, snapshotName, this.client.getApiVersion(), body, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, Object body, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (snapshotName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, snapshotName, this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SnapshotInner>, SnapshotInner> beginUpdateAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, Object body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, snapshotName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)SnapshotInner.class), (Type)((Object)SnapshotInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SnapshotInner>, SnapshotInner> beginUpdate(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, Object body) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, accountName, poolName, volumeName, snapshotName, body);
        return this.client.getLroResult(response, (Type)((Object)SnapshotInner.class), (Type)((Object)SnapshotInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SnapshotInner>, SnapshotInner> beginUpdate(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, Object body, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, accountName, poolName, volumeName, snapshotName, body, context);
        return this.client.getLroResult(response, (Type)((Object)SnapshotInner.class), (Type)((Object)SnapshotInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SnapshotInner> updateAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, Object body) {
        return this.beginUpdateAsync(resourceGroupName, accountName, poolName, volumeName, snapshotName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SnapshotInner update(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, Object body) {
        return (SnapshotInner)((Object)this.beginUpdate(resourceGroupName, accountName, poolName, volumeName, snapshotName, body).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SnapshotInner update(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, Object body, Context context) {
        return (SnapshotInner)((Object)this.beginUpdate(resourceGroupName, accountName, poolName, volumeName, snapshotName, body, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (snapshotName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, snapshotName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (snapshotName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, snapshotName, this.client.getApiVersion(), "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (snapshotName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, snapshotName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, snapshotName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, accountName, poolName, volumeName, snapshotName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, accountName, poolName, volumeName, snapshotName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName) {
        return this.beginDeleteAsync(resourceGroupName, accountName, poolName, volumeName, snapshotName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName) {
        this.beginDelete(resourceGroupName, accountName, poolName, volumeName, snapshotName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, Context context) {
        this.beginDelete(resourceGroupName, accountName, poolName, volumeName, snapshotName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restoreFilesWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotRestoreFiles body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (snapshotName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restoreFiles(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, snapshotName, this.client.getApiVersion(), body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> restoreFilesWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotRestoreFiles body) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (snapshotName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return this.service.restoreFilesSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, snapshotName, this.client.getApiVersion(), body, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> restoreFilesWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotRestoreFiles body, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (snapshotName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return this.service.restoreFilesSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, snapshotName, this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRestoreFilesAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotRestoreFiles body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restoreFilesWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, snapshotName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestoreFiles(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotRestoreFiles body) {
        Response<BinaryData> response = this.restoreFilesWithResponse(resourceGroupName, accountName, poolName, volumeName, snapshotName, body);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestoreFiles(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotRestoreFiles body, Context context) {
        Response<BinaryData> response = this.restoreFilesWithResponse(resourceGroupName, accountName, poolName, volumeName, snapshotName, body, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> restoreFilesAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotRestoreFiles body) {
        return this.beginRestoreFilesAsync(resourceGroupName, accountName, poolName, volumeName, snapshotName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restoreFiles(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotRestoreFiles body) {
        this.beginRestoreFiles(resourceGroupName, accountName, poolName, volumeName, snapshotName, body).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restoreFiles(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotRestoreFiles body, Context context) {
        this.beginRestoreFiles(resourceGroupName, accountName, poolName, volumeName, snapshotName, body, context).getFinalResult();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetAppManagementClientSnapshots")
    public static interface SnapshotsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/snapshots")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SnapshotsList>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="volumeName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/snapshots")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SnapshotsList> listSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="volumeName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/snapshots/{snapshotName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SnapshotInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="volumeName") String var6, @PathParam(value="snapshotName") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/snapshots/{snapshotName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SnapshotInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="volumeName") String var6, @PathParam(value="snapshotName") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/snapshots/{snapshotName}")
        @ExpectedResponses(value={201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="volumeName") String var6, @PathParam(value="snapshotName") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") SnapshotInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/snapshots/{snapshotName}")
        @ExpectedResponses(value={201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="volumeName") String var6, @PathParam(value="snapshotName") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") SnapshotInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/snapshots/{snapshotName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="volumeName") String var6, @PathParam(value="snapshotName") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") Object var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/snapshots/{snapshotName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="volumeName") String var6, @PathParam(value="snapshotName") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") Object var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/snapshots/{snapshotName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="volumeName") String var6, @PathParam(value="snapshotName") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/snapshots/{snapshotName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="volumeName") String var6, @PathParam(value="snapshotName") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/snapshots/{snapshotName}/restoreFiles")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> restoreFiles(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="volumeName") String var6, @PathParam(value="snapshotName") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") SnapshotRestoreFiles var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/snapshots/{snapshotName}/restoreFiles")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> restoreFilesSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="volumeName") String var6, @PathParam(value="snapshotName") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") SnapshotRestoreFiles var9, @HeaderParam(value="Accept") String var10, Context var11);
    }
}

