/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.RegionInfoInner;
import com.azure.resourcemanager.netapp.models.RegionInfoAvailabilityZoneMappingsItem;
import com.azure.resourcemanager.netapp.models.RegionStorageToNetworkProximity;
import java.io.IOException;
import java.util.List;

public final class RegionInfoResourceInner
extends ProxyResource {
    private RegionInfoInner innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private RegionInfoInner innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public RegionStorageToNetworkProximity storageToNetworkProximity() {
        return this.innerProperties() == null ? null : this.innerProperties().storageToNetworkProximity();
    }

    public RegionInfoResourceInner withStorageToNetworkProximity(RegionStorageToNetworkProximity storageToNetworkProximity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegionInfoInner();
        }
        this.innerProperties().withStorageToNetworkProximity(storageToNetworkProximity);
        return this;
    }

    public List<RegionInfoAvailabilityZoneMappingsItem> availabilityZoneMappings() {
        return this.innerProperties() == null ? null : this.innerProperties().availabilityZoneMappings();
    }

    public RegionInfoResourceInner withAvailabilityZoneMappings(List<RegionInfoAvailabilityZoneMappingsItem> availabilityZoneMappings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegionInfoInner();
        }
        this.innerProperties().withAvailabilityZoneMappings(availabilityZoneMappings);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RegionInfoResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (RegionInfoResourceInner)((Object)jsonReader.readObject(reader -> {
            RegionInfoResourceInner deserializedRegionInfoResourceInner = new RegionInfoResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRegionInfoResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRegionInfoResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRegionInfoResourceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRegionInfoResourceInner.innerProperties = RegionInfoInner.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedRegionInfoResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRegionInfoResourceInner;
        }));
    }
}

