/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.VolumePatchProperties;
import com.azure.resourcemanager.netapp.models.CoolAccessRetrievalPolicy;
import com.azure.resourcemanager.netapp.models.CoolAccessTieringPolicy;
import com.azure.resourcemanager.netapp.models.ServiceLevel;
import com.azure.resourcemanager.netapp.models.SmbAccessBasedEnumeration;
import com.azure.resourcemanager.netapp.models.SmbNonBrowsable;
import com.azure.resourcemanager.netapp.models.VolumePatchPropertiesDataProtection;
import com.azure.resourcemanager.netapp.models.VolumePatchPropertiesExportPolicy;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VolumePatch
extends Resource {
    private VolumePatchProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private VolumePatchProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public VolumePatch withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VolumePatch withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ServiceLevel serviceLevel() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceLevel();
    }

    public VolumePatch withServiceLevel(ServiceLevel serviceLevel) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumePatchProperties();
        }
        this.innerProperties().withServiceLevel(serviceLevel);
        return this;
    }

    public Long usageThreshold() {
        return this.innerProperties() == null ? null : this.innerProperties().usageThreshold();
    }

    public VolumePatch withUsageThreshold(Long usageThreshold) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumePatchProperties();
        }
        this.innerProperties().withUsageThreshold(usageThreshold);
        return this;
    }

    public VolumePatchPropertiesExportPolicy exportPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().exportPolicy();
    }

    public VolumePatch withExportPolicy(VolumePatchPropertiesExportPolicy exportPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumePatchProperties();
        }
        this.innerProperties().withExportPolicy(exportPolicy);
        return this;
    }

    public List<String> protocolTypes() {
        return this.innerProperties() == null ? null : this.innerProperties().protocolTypes();
    }

    public VolumePatch withProtocolTypes(List<String> protocolTypes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumePatchProperties();
        }
        this.innerProperties().withProtocolTypes(protocolTypes);
        return this;
    }

    public Float throughputMibps() {
        return this.innerProperties() == null ? null : this.innerProperties().throughputMibps();
    }

    public VolumePatch withThroughputMibps(Float throughputMibps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumePatchProperties();
        }
        this.innerProperties().withThroughputMibps(throughputMibps);
        return this;
    }

    public VolumePatchPropertiesDataProtection dataProtection() {
        return this.innerProperties() == null ? null : this.innerProperties().dataProtection();
    }

    public VolumePatch withDataProtection(VolumePatchPropertiesDataProtection dataProtection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumePatchProperties();
        }
        this.innerProperties().withDataProtection(dataProtection);
        return this;
    }

    public Boolean isDefaultQuotaEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isDefaultQuotaEnabled();
    }

    public VolumePatch withIsDefaultQuotaEnabled(Boolean isDefaultQuotaEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumePatchProperties();
        }
        this.innerProperties().withIsDefaultQuotaEnabled(isDefaultQuotaEnabled);
        return this;
    }

    public Long defaultUserQuotaInKiBs() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultUserQuotaInKiBs();
    }

    public VolumePatch withDefaultUserQuotaInKiBs(Long defaultUserQuotaInKiBs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumePatchProperties();
        }
        this.innerProperties().withDefaultUserQuotaInKiBs(defaultUserQuotaInKiBs);
        return this;
    }

    public Long defaultGroupQuotaInKiBs() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultGroupQuotaInKiBs();
    }

    public VolumePatch withDefaultGroupQuotaInKiBs(Long defaultGroupQuotaInKiBs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumePatchProperties();
        }
        this.innerProperties().withDefaultGroupQuotaInKiBs(defaultGroupQuotaInKiBs);
        return this;
    }

    public String unixPermissions() {
        return this.innerProperties() == null ? null : this.innerProperties().unixPermissions();
    }

    public VolumePatch withUnixPermissions(String unixPermissions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumePatchProperties();
        }
        this.innerProperties().withUnixPermissions(unixPermissions);
        return this;
    }

    public Boolean coolAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().coolAccess();
    }

    public VolumePatch withCoolAccess(Boolean coolAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumePatchProperties();
        }
        this.innerProperties().withCoolAccess(coolAccess);
        return this;
    }

    public Integer coolnessPeriod() {
        return this.innerProperties() == null ? null : this.innerProperties().coolnessPeriod();
    }

    public VolumePatch withCoolnessPeriod(Integer coolnessPeriod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumePatchProperties();
        }
        this.innerProperties().withCoolnessPeriod(coolnessPeriod);
        return this;
    }

    public CoolAccessRetrievalPolicy coolAccessRetrievalPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().coolAccessRetrievalPolicy();
    }

    public VolumePatch withCoolAccessRetrievalPolicy(CoolAccessRetrievalPolicy coolAccessRetrievalPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumePatchProperties();
        }
        this.innerProperties().withCoolAccessRetrievalPolicy(coolAccessRetrievalPolicy);
        return this;
    }

    public CoolAccessTieringPolicy coolAccessTieringPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().coolAccessTieringPolicy();
    }

    public VolumePatch withCoolAccessTieringPolicy(CoolAccessTieringPolicy coolAccessTieringPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumePatchProperties();
        }
        this.innerProperties().withCoolAccessTieringPolicy(coolAccessTieringPolicy);
        return this;
    }

    public Boolean snapshotDirectoryVisible() {
        return this.innerProperties() == null ? null : this.innerProperties().snapshotDirectoryVisible();
    }

    public VolumePatch withSnapshotDirectoryVisible(Boolean snapshotDirectoryVisible) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumePatchProperties();
        }
        this.innerProperties().withSnapshotDirectoryVisible(snapshotDirectoryVisible);
        return this;
    }

    public SmbAccessBasedEnumeration smbAccessBasedEnumeration() {
        return this.innerProperties() == null ? null : this.innerProperties().smbAccessBasedEnumeration();
    }

    public VolumePatch withSmbAccessBasedEnumeration(SmbAccessBasedEnumeration smbAccessBasedEnumeration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumePatchProperties();
        }
        this.innerProperties().withSmbAccessBasedEnumeration(smbAccessBasedEnumeration);
        return this;
    }

    public SmbNonBrowsable smbNonBrowsable() {
        return this.innerProperties() == null ? null : this.innerProperties().smbNonBrowsable();
    }

    public VolumePatch withSmbNonBrowsable(SmbNonBrowsable smbNonBrowsable) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumePatchProperties();
        }
        this.innerProperties().withSmbNonBrowsable(smbNonBrowsable);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VolumePatch fromJson(JsonReader jsonReader) throws IOException {
        return (VolumePatch)((Object)jsonReader.readObject(reader -> {
            VolumePatch deserializedVolumePatch = new VolumePatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVolumePatch.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVolumePatch.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVolumePatch.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVolumePatch.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVolumePatch.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVolumePatch.innerProperties = VolumePatchProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumePatch;
        }));
    }
}

