/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.SnapshotPolicyProperties;
import com.azure.resourcemanager.netapp.models.DailySchedule;
import com.azure.resourcemanager.netapp.models.HourlySchedule;
import com.azure.resourcemanager.netapp.models.MonthlySchedule;
import com.azure.resourcemanager.netapp.models.WeeklySchedule;
import java.io.IOException;
import java.util.Map;

public final class SnapshotPolicyPatch
implements JsonSerializable<SnapshotPolicyPatch> {
    private String location;
    private String id;
    private String name;
    private String type;
    private Map<String, String> tags;
    private SnapshotPolicyProperties innerProperties;

    public String location() {
        return this.location;
    }

    public SnapshotPolicyPatch withLocation(String location) {
        this.location = location;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public SnapshotPolicyPatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private SnapshotPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    public HourlySchedule hourlySchedule() {
        return this.innerProperties() == null ? null : this.innerProperties().hourlySchedule();
    }

    public SnapshotPolicyPatch withHourlySchedule(HourlySchedule hourlySchedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotPolicyProperties();
        }
        this.innerProperties().withHourlySchedule(hourlySchedule);
        return this;
    }

    public DailySchedule dailySchedule() {
        return this.innerProperties() == null ? null : this.innerProperties().dailySchedule();
    }

    public SnapshotPolicyPatch withDailySchedule(DailySchedule dailySchedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotPolicyProperties();
        }
        this.innerProperties().withDailySchedule(dailySchedule);
        return this;
    }

    public WeeklySchedule weeklySchedule() {
        return this.innerProperties() == null ? null : this.innerProperties().weeklySchedule();
    }

    public SnapshotPolicyPatch withWeeklySchedule(WeeklySchedule weeklySchedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotPolicyProperties();
        }
        this.innerProperties().withWeeklySchedule(weeklySchedule);
        return this;
    }

    public MonthlySchedule monthlySchedule() {
        return this.innerProperties() == null ? null : this.innerProperties().monthlySchedule();
    }

    public SnapshotPolicyPatch withMonthlySchedule(MonthlySchedule monthlySchedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotPolicyProperties();
        }
        this.innerProperties().withMonthlySchedule(monthlySchedule);
        return this;
    }

    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    public SnapshotPolicyPatch withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotPolicyProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SnapshotPolicyPatch fromJson(JsonReader jsonReader) throws IOException {
        return (SnapshotPolicyPatch)jsonReader.readObject(reader -> {
            SnapshotPolicyPatch deserializedSnapshotPolicyPatch = new SnapshotPolicyPatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedSnapshotPolicyPatch.location = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedSnapshotPolicyPatch.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSnapshotPolicyPatch.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSnapshotPolicyPatch.type = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedSnapshotPolicyPatch.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSnapshotPolicyPatch.innerProperties = SnapshotPolicyProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSnapshotPolicyPatch;
        });
    }
}

