/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.KeyVaultStatus;
import java.io.IOException;

public final class KeyVaultProperties
implements JsonSerializable<KeyVaultProperties> {
    private String keyVaultId;
    private String keyVaultUri;
    private String keyName;
    private String keyVaultResourceId;
    private KeyVaultStatus status;
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultProperties.class);

    public String keyVaultId() {
        return this.keyVaultId;
    }

    public String keyVaultUri() {
        return this.keyVaultUri;
    }

    public KeyVaultProperties withKeyVaultUri(String keyVaultUri) {
        this.keyVaultUri = keyVaultUri;
        return this;
    }

    public String keyName() {
        return this.keyName;
    }

    public KeyVaultProperties withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public String keyVaultResourceId() {
        return this.keyVaultResourceId;
    }

    public KeyVaultProperties withKeyVaultResourceId(String keyVaultResourceId) {
        this.keyVaultResourceId = keyVaultResourceId;
        return this;
    }

    public KeyVaultStatus status() {
        return this.status;
    }

    public void validate() {
        if (this.keyVaultUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyVaultUri in model KeyVaultProperties"));
        }
        if (this.keyName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyName in model KeyVaultProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyVaultUri", this.keyVaultUri);
        jsonWriter.writeStringField("keyName", this.keyName);
        jsonWriter.writeStringField("keyVaultResourceId", this.keyVaultResourceId);
        return jsonWriter.writeEndObject();
    }

    public static KeyVaultProperties fromJson(JsonReader jsonReader) throws IOException {
        return (KeyVaultProperties)jsonReader.readObject(reader -> {
            KeyVaultProperties deserializedKeyVaultProperties = new KeyVaultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyVaultUri".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyVaultUri = reader.getString();
                    continue;
                }
                if ("keyName".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyName = reader.getString();
                    continue;
                }
                if ("keyVaultId".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyVaultId = reader.getString();
                    continue;
                }
                if ("keyVaultResourceId".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyVaultResourceId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedKeyVaultProperties.status = KeyVaultStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyVaultProperties;
        });
    }
}

