/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.KeyVaultPrivateEndpoint;
import java.io.IOException;
import java.util.List;

public final class ChangeKeyVault
implements JsonSerializable<ChangeKeyVault> {
    private String keyVaultUri;
    private String keyName;
    private String keyVaultResourceId;
    private List<KeyVaultPrivateEndpoint> keyVaultPrivateEndpoints;
    private static final ClientLogger LOGGER = new ClientLogger(ChangeKeyVault.class);

    public String keyVaultUri() {
        return this.keyVaultUri;
    }

    public ChangeKeyVault withKeyVaultUri(String keyVaultUri) {
        this.keyVaultUri = keyVaultUri;
        return this;
    }

    public String keyName() {
        return this.keyName;
    }

    public ChangeKeyVault withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public String keyVaultResourceId() {
        return this.keyVaultResourceId;
    }

    public ChangeKeyVault withKeyVaultResourceId(String keyVaultResourceId) {
        this.keyVaultResourceId = keyVaultResourceId;
        return this;
    }

    public List<KeyVaultPrivateEndpoint> keyVaultPrivateEndpoints() {
        return this.keyVaultPrivateEndpoints;
    }

    public ChangeKeyVault withKeyVaultPrivateEndpoints(List<KeyVaultPrivateEndpoint> keyVaultPrivateEndpoints) {
        this.keyVaultPrivateEndpoints = keyVaultPrivateEndpoints;
        return this;
    }

    public void validate() {
        if (this.keyVaultUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyVaultUri in model ChangeKeyVault"));
        }
        if (this.keyName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyName in model ChangeKeyVault"));
        }
        if (this.keyVaultPrivateEndpoints() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyVaultPrivateEndpoints in model ChangeKeyVault"));
        }
        this.keyVaultPrivateEndpoints().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyVaultUri", this.keyVaultUri);
        jsonWriter.writeStringField("keyName", this.keyName);
        jsonWriter.writeArrayField("keyVaultPrivateEndpoints", this.keyVaultPrivateEndpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("keyVaultResourceId", this.keyVaultResourceId);
        return jsonWriter.writeEndObject();
    }

    public static ChangeKeyVault fromJson(JsonReader jsonReader) throws IOException {
        return (ChangeKeyVault)jsonReader.readObject(reader -> {
            ChangeKeyVault deserializedChangeKeyVault = new ChangeKeyVault();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyVaultUri".equals(fieldName)) {
                    deserializedChangeKeyVault.keyVaultUri = reader.getString();
                    continue;
                }
                if ("keyName".equals(fieldName)) {
                    deserializedChangeKeyVault.keyName = reader.getString();
                    continue;
                }
                if ("keyVaultPrivateEndpoints".equals(fieldName)) {
                    List keyVaultPrivateEndpoints;
                    deserializedChangeKeyVault.keyVaultPrivateEndpoints = keyVaultPrivateEndpoints = reader.readArray(reader1 -> KeyVaultPrivateEndpoint.fromJson(reader1));
                    continue;
                }
                if ("keyVaultResourceId".equals(fieldName)) {
                    deserializedChangeKeyVault.keyVaultResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChangeKeyVault;
        });
    }
}

