/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.PoolPatchProperties;
import com.azure.resourcemanager.netapp.models.QosType;
import java.io.IOException;
import java.util.Map;

public final class CapacityPoolPatch
extends Resource {
    private PoolPatchProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private PoolPatchProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public CapacityPoolPatch withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public CapacityPoolPatch withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Long size() {
        return this.innerProperties() == null ? null : this.innerProperties().size();
    }

    public CapacityPoolPatch withSize(Long size) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolPatchProperties();
        }
        this.innerProperties().withSize(size);
        return this;
    }

    public QosType qosType() {
        return this.innerProperties() == null ? null : this.innerProperties().qosType();
    }

    public CapacityPoolPatch withQosType(QosType qosType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolPatchProperties();
        }
        this.innerProperties().withQosType(qosType);
        return this;
    }

    public Boolean coolAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().coolAccess();
    }

    public CapacityPoolPatch withCoolAccess(Boolean coolAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolPatchProperties();
        }
        this.innerProperties().withCoolAccess(coolAccess);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CapacityPoolPatch fromJson(JsonReader jsonReader) throws IOException {
        return (CapacityPoolPatch)((Object)jsonReader.readObject(reader -> {
            CapacityPoolPatch deserializedCapacityPoolPatch = new CapacityPoolPatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCapacityPoolPatch.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCapacityPoolPatch.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCapacityPoolPatch.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedCapacityPoolPatch.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCapacityPoolPatch.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCapacityPoolPatch.innerProperties = PoolPatchProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCapacityPoolPatch;
        }));
    }
}

