/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.netapp.fluent.VolumeQuotaRulesClient;
import com.azure.resourcemanager.netapp.fluent.models.VolumeQuotaRuleInner;
import com.azure.resourcemanager.netapp.implementation.NetAppManagementClientImpl;
import com.azure.resourcemanager.netapp.models.VolumeQuotaRulePatch;
import com.azure.resourcemanager.netapp.models.VolumeQuotaRulesList;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VolumeQuotaRulesClientImpl
implements VolumeQuotaRulesClient {
    private final VolumeQuotaRulesService service;
    private final NetAppManagementClientImpl client;

    VolumeQuotaRulesClientImpl(NetAppManagementClientImpl client) {
        this.service = (VolumeQuotaRulesService)RestProxy.create(VolumeQuotaRulesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VolumeQuotaRuleInner>> listByVolumeSinglePageAsync(String resourceGroupName, String accountName, String poolName, String volumeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByVolume(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VolumeQuotaRulesList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VolumeQuotaRuleInner>> listByVolumeSinglePageAsync(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByVolume(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VolumeQuotaRulesList)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VolumeQuotaRuleInner> listByVolumeAsync(String resourceGroupName, String accountName, String poolName, String volumeName) {
        return new PagedFlux(() -> this.listByVolumeSinglePageAsync(resourceGroupName, accountName, poolName, volumeName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VolumeQuotaRuleInner> listByVolumeAsync(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        return new PagedFlux(() -> this.listByVolumeSinglePageAsync(resourceGroupName, accountName, poolName, volumeName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VolumeQuotaRuleInner> listByVolume(String resourceGroupName, String accountName, String poolName, String volumeName) {
        return new PagedIterable(this.listByVolumeAsync(resourceGroupName, accountName, poolName, volumeName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VolumeQuotaRuleInner> listByVolume(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        return new PagedIterable(this.listByVolumeAsync(resourceGroupName, accountName, poolName, volumeName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VolumeQuotaRuleInner>> getWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (volumeQuotaRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeQuotaRuleName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VolumeQuotaRuleInner>> getWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (volumeQuotaRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeQuotaRuleName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VolumeQuotaRuleInner> getAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName) {
        return this.getWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((VolumeQuotaRuleInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VolumeQuotaRuleInner> getWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VolumeQuotaRuleInner get(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName) {
        return (VolumeQuotaRuleInner)((Object)this.getWithResponse(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRuleInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (volumeQuotaRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeQuotaRuleName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, this.client.getApiVersion(), body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRuleInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (volumeQuotaRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeQuotaRuleName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VolumeQuotaRuleInner>, VolumeQuotaRuleInner> beginCreateAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRuleInner body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)VolumeQuotaRuleInner.class), (Type)((Object)VolumeQuotaRuleInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VolumeQuotaRuleInner>, VolumeQuotaRuleInner> beginCreateAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRuleInner body, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, body, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)VolumeQuotaRuleInner.class), (Type)((Object)VolumeQuotaRuleInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VolumeQuotaRuleInner>, VolumeQuotaRuleInner> beginCreate(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRuleInner body) {
        return this.beginCreateAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, body).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VolumeQuotaRuleInner>, VolumeQuotaRuleInner> beginCreate(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRuleInner body, Context context) {
        return this.beginCreateAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, body, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VolumeQuotaRuleInner> createAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRuleInner body) {
        return this.beginCreateAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VolumeQuotaRuleInner> createAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRuleInner body, Context context) {
        return this.beginCreateAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, body, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VolumeQuotaRuleInner create(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRuleInner body) {
        return (VolumeQuotaRuleInner)((Object)this.createAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, body).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VolumeQuotaRuleInner create(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRuleInner body, Context context) {
        return (VolumeQuotaRuleInner)((Object)this.createAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, body, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRulePatch body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (volumeQuotaRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeQuotaRuleName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, this.client.getApiVersion(), body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRulePatch body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (volumeQuotaRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeQuotaRuleName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VolumeQuotaRuleInner>, VolumeQuotaRuleInner> beginUpdateAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRulePatch body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)VolumeQuotaRuleInner.class), (Type)((Object)VolumeQuotaRuleInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VolumeQuotaRuleInner>, VolumeQuotaRuleInner> beginUpdateAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRulePatch body, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, body, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)VolumeQuotaRuleInner.class), (Type)((Object)VolumeQuotaRuleInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VolumeQuotaRuleInner>, VolumeQuotaRuleInner> beginUpdate(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRulePatch body) {
        return this.beginUpdateAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, body).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VolumeQuotaRuleInner>, VolumeQuotaRuleInner> beginUpdate(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRulePatch body, Context context) {
        return this.beginUpdateAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, body, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VolumeQuotaRuleInner> updateAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRulePatch body) {
        return this.beginUpdateAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VolumeQuotaRuleInner> updateAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRulePatch body, Context context) {
        return this.beginUpdateAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, body, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VolumeQuotaRuleInner update(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRulePatch body) {
        return (VolumeQuotaRuleInner)((Object)this.updateAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, body).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VolumeQuotaRuleInner update(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, VolumeQuotaRulePatch body, Context context) {
        return (VolumeQuotaRuleInner)((Object)this.updateAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, body, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (volumeQuotaRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeQuotaRuleName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (volumeQuotaRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeQuotaRuleName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName) {
        return this.beginDeleteAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName) {
        return this.beginDeleteAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName) {
        this.deleteAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, Context context) {
        this.deleteAsync(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetAppManagementClie")
    public static interface VolumeQuotaRulesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/volumeQuotaRules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VolumeQuotaRulesList>> listByVolume(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="volumeName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/volumeQuotaRules/{volumeQuotaRuleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VolumeQuotaRuleInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="volumeName") String var6, @PathParam(value="volumeQuotaRuleName") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/volumeQuotaRules/{volumeQuotaRuleName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="volumeName") String var6, @PathParam(value="volumeQuotaRuleName") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") VolumeQuotaRuleInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/volumeQuotaRules/{volumeQuotaRuleName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="volumeName") String var6, @PathParam(value="volumeQuotaRuleName") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") VolumeQuotaRulePatch var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/volumeQuotaRules/{volumeQuotaRuleName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="volumeName") String var6, @PathParam(value="volumeQuotaRuleName") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);
    }
}

