/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.SnapshotPolicyInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.DailySchedule;
import com.azure.resourcemanager.netapp.models.HourlySchedule;
import com.azure.resourcemanager.netapp.models.MonthlySchedule;
import com.azure.resourcemanager.netapp.models.SnapshotPolicy;
import com.azure.resourcemanager.netapp.models.SnapshotPolicyPatch;
import com.azure.resourcemanager.netapp.models.WeeklySchedule;
import java.util.Collections;
import java.util.Map;

public final class SnapshotPolicyImpl
implements SnapshotPolicy,
SnapshotPolicy.Definition,
SnapshotPolicy.Update {
    private SnapshotPolicyInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String snapshotPolicyName;
    private SnapshotPolicyPatch updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public HourlySchedule hourlySchedule() {
        return this.innerModel().hourlySchedule();
    }

    @Override
    public DailySchedule dailySchedule() {
        return this.innerModel().dailySchedule();
    }

    @Override
    public WeeklySchedule weeklySchedule() {
        return this.innerModel().weeklySchedule();
    }

    @Override
    public MonthlySchedule monthlySchedule() {
        return this.innerModel().monthlySchedule();
    }

    @Override
    public Boolean enabled() {
        return this.innerModel().enabled();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SnapshotPolicyInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public SnapshotPolicyImpl withExistingNetAppAccount(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public SnapshotPolicy create() {
        this.innerObject = (SnapshotPolicyInner)((Object)this.serviceManager.serviceClient().getSnapshotPolicies().createWithResponse(this.resourceGroupName, this.accountName, this.snapshotPolicyName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public SnapshotPolicy create(Context context) {
        this.innerObject = (SnapshotPolicyInner)((Object)this.serviceManager.serviceClient().getSnapshotPolicies().createWithResponse(this.resourceGroupName, this.accountName, this.snapshotPolicyName, this.innerModel(), context).getValue());
        return this;
    }

    SnapshotPolicyImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new SnapshotPolicyInner();
        this.serviceManager = serviceManager;
        this.snapshotPolicyName = name;
    }

    @Override
    public SnapshotPolicyImpl update() {
        this.updateBody = new SnapshotPolicyPatch();
        return this;
    }

    @Override
    public SnapshotPolicy apply() {
        this.innerObject = this.serviceManager.serviceClient().getSnapshotPolicies().update(this.resourceGroupName, this.accountName, this.snapshotPolicyName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public SnapshotPolicy apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSnapshotPolicies().update(this.resourceGroupName, this.accountName, this.snapshotPolicyName, this.updateBody, context);
        return this;
    }

    SnapshotPolicyImpl(SnapshotPolicyInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "netAppAccounts");
        this.snapshotPolicyName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "snapshotPolicies");
    }

    @Override
    public SnapshotPolicy refresh() {
        this.innerObject = (SnapshotPolicyInner)((Object)this.serviceManager.serviceClient().getSnapshotPolicies().getWithResponse(this.resourceGroupName, this.accountName, this.snapshotPolicyName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SnapshotPolicy refresh(Context context) {
        this.innerObject = (SnapshotPolicyInner)((Object)this.serviceManager.serviceClient().getSnapshotPolicies().getWithResponse(this.resourceGroupName, this.accountName, this.snapshotPolicyName, context).getValue());
        return this;
    }

    @Override
    public SnapshotPolicyImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public SnapshotPolicyImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public SnapshotPolicyImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBody.withTags(tags);
        return this;
    }

    @Override
    public SnapshotPolicyImpl withHourlySchedule(HourlySchedule hourlySchedule) {
        if (this.isInCreateMode()) {
            this.innerModel().withHourlySchedule(hourlySchedule);
            return this;
        }
        this.updateBody.withHourlySchedule(hourlySchedule);
        return this;
    }

    @Override
    public SnapshotPolicyImpl withDailySchedule(DailySchedule dailySchedule) {
        if (this.isInCreateMode()) {
            this.innerModel().withDailySchedule(dailySchedule);
            return this;
        }
        this.updateBody.withDailySchedule(dailySchedule);
        return this;
    }

    @Override
    public SnapshotPolicyImpl withWeeklySchedule(WeeklySchedule weeklySchedule) {
        if (this.isInCreateMode()) {
            this.innerModel().withWeeklySchedule(weeklySchedule);
            return this;
        }
        this.updateBody.withWeeklySchedule(weeklySchedule);
        return this;
    }

    @Override
    public SnapshotPolicyImpl withMonthlySchedule(MonthlySchedule monthlySchedule) {
        if (this.isInCreateMode()) {
            this.innerModel().withMonthlySchedule(monthlySchedule);
            return this;
        }
        this.updateBody.withMonthlySchedule(monthlySchedule);
        return this;
    }

    @Override
    public SnapshotPolicyImpl withEnabled(Boolean enabled) {
        if (this.isInCreateMode()) {
            this.innerModel().withEnabled(enabled);
            return this;
        }
        this.updateBody.withEnabled(enabled);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

