/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.netapp.fluent.NetAppResourceQuotaLimitsClient;
import com.azure.resourcemanager.netapp.fluent.models.SubscriptionQuotaItemInner;
import com.azure.resourcemanager.netapp.implementation.NetAppManagementClientImpl;
import com.azure.resourcemanager.netapp.models.SubscriptionQuotaItemList;
import reactor.core.publisher.Mono;

public final class NetAppResourceQuotaLimitsClientImpl
implements NetAppResourceQuotaLimitsClient {
    private final NetAppResourceQuotaLimitsService service;
    private final NetAppManagementClientImpl client;

    NetAppResourceQuotaLimitsClientImpl(NetAppManagementClientImpl client) {
        this.service = (NetAppResourceQuotaLimitsService)RestProxy.create(NetAppResourceQuotaLimitsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SubscriptionQuotaItemInner>> listSinglePageAsync(String location) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), location, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SubscriptionQuotaItemList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SubscriptionQuotaItemInner>> listSinglePageAsync(String location, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), location, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SubscriptionQuotaItemList)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SubscriptionQuotaItemInner> listAsync(String location) {
        return new PagedFlux(() -> this.listSinglePageAsync(location));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SubscriptionQuotaItemInner> listAsync(String location, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(location, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SubscriptionQuotaItemInner> list(String location) {
        return new PagedIterable(this.listAsync(location));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SubscriptionQuotaItemInner> list(String location, Context context) {
        return new PagedIterable(this.listAsync(location, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SubscriptionQuotaItemInner>> getWithResponseAsync(String location, String quotaLimitName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (quotaLimitName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter quotaLimitName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), location, quotaLimitName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SubscriptionQuotaItemInner>> getWithResponseAsync(String location, String quotaLimitName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (quotaLimitName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter quotaLimitName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), location, quotaLimitName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SubscriptionQuotaItemInner> getAsync(String location, String quotaLimitName) {
        return this.getWithResponseAsync(location, quotaLimitName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SubscriptionQuotaItemInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SubscriptionQuotaItemInner> getWithResponse(String location, String quotaLimitName, Context context) {
        return (Response)this.getWithResponseAsync(location, quotaLimitName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionQuotaItemInner get(String location, String quotaLimitName) {
        return (SubscriptionQuotaItemInner)((Object)this.getWithResponse(location, quotaLimitName, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetAppManagementClie")
    public static interface NetAppResourceQuotaLimitsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.NetApp/locations/{location}/quotaLimits")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SubscriptionQuotaItemList>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="location") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.NetApp/locations/{location}/quotaLimits/{quotaLimitName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SubscriptionQuotaItemInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="location") String var3, @PathParam(value="quotaLimitName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

