/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.BackupsClient;
import com.azure.resourcemanager.netapp.fluent.models.BackupInner;
import com.azure.resourcemanager.netapp.fluent.models.BackupStatusInner;
import com.azure.resourcemanager.netapp.fluent.models.RestoreStatusInner;
import com.azure.resourcemanager.netapp.implementation.BackupImpl;
import com.azure.resourcemanager.netapp.implementation.BackupStatusImpl;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.implementation.RestoreStatusImpl;
import com.azure.resourcemanager.netapp.models.Backup;
import com.azure.resourcemanager.netapp.models.BackupStatus;
import com.azure.resourcemanager.netapp.models.Backups;
import com.azure.resourcemanager.netapp.models.RestoreStatus;

public final class BackupsImpl
implements Backups {
    private static final ClientLogger LOGGER = new ClientLogger(BackupsImpl.class);
    private final BackupsClient innerClient;
    private final NetAppFilesManager serviceManager;

    public BackupsImpl(BackupsClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<BackupStatus> getLatestStatusWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        Response<BackupStatusInner> inner = this.serviceClient().getLatestStatusWithResponse(resourceGroupName, accountName, poolName, volumeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BackupStatusImpl((BackupStatusInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public BackupStatus getLatestStatus(String resourceGroupName, String accountName, String poolName, String volumeName) {
        BackupStatusInner inner = this.serviceClient().getLatestStatus(resourceGroupName, accountName, poolName, volumeName);
        if (inner != null) {
            return new BackupStatusImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<RestoreStatus> getVolumeLatestRestoreStatusWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        Response<RestoreStatusInner> inner = this.serviceClient().getVolumeLatestRestoreStatusWithResponse(resourceGroupName, accountName, poolName, volumeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RestoreStatusImpl((RestoreStatusInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public RestoreStatus getVolumeLatestRestoreStatus(String resourceGroupName, String accountName, String poolName, String volumeName) {
        RestoreStatusInner inner = this.serviceClient().getVolumeLatestRestoreStatus(resourceGroupName, accountName, poolName, volumeName);
        if (inner != null) {
            return new RestoreStatusImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Backup> listByVault(String resourceGroupName, String accountName, String backupVaultName) {
        PagedIterable<BackupInner> inner = this.serviceClient().listByVault(resourceGroupName, accountName, backupVaultName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackupImpl((BackupInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Backup> listByVault(String resourceGroupName, String accountName, String backupVaultName, String filter, Context context) {
        PagedIterable<BackupInner> inner = this.serviceClient().listByVault(resourceGroupName, accountName, backupVaultName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackupImpl((BackupInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Backup> getWithResponse(String resourceGroupName, String accountName, String backupVaultName, String backupName, Context context) {
        Response<BackupInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, backupVaultName, backupName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BackupImpl((BackupInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Backup get(String resourceGroupName, String accountName, String backupVaultName, String backupName) {
        BackupInner inner = this.serviceClient().get(resourceGroupName, accountName, backupVaultName, backupName);
        if (inner != null) {
            return new BackupImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String backupVaultName, String backupName) {
        this.serviceClient().delete(resourceGroupName, accountName, backupVaultName, backupName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String backupVaultName, String backupName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, backupVaultName, backupName, context);
    }

    @Override
    public Backup getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String backupVaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (backupVaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        String backupName = ResourceManagerUtils.getValueFromIdByName(id, "backups");
        if (backupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backups'.", id)));
        }
        return (Backup)this.getWithResponse(resourceGroupName, accountName, backupVaultName, backupName, Context.NONE).getValue();
    }

    @Override
    public Response<Backup> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String backupVaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (backupVaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        String backupName = ResourceManagerUtils.getValueFromIdByName(id, "backups");
        if (backupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backups'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, backupVaultName, backupName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String backupVaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (backupVaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        String backupName = ResourceManagerUtils.getValueFromIdByName(id, "backups");
        if (backupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backups'.", id)));
        }
        this.delete(resourceGroupName, accountName, backupVaultName, backupName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String backupVaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (backupVaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        String backupName = ResourceManagerUtils.getValueFromIdByName(id, "backups");
        if (backupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backups'.", id)));
        }
        this.delete(resourceGroupName, accountName, backupVaultName, backupName, context);
    }

    private BackupsClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public BackupImpl define(String name) {
        return new BackupImpl(name, this.manager());
    }
}

