/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.DailySchedule;
import com.azure.resourcemanager.netapp.models.HourlySchedule;
import com.azure.resourcemanager.netapp.models.MonthlySchedule;
import com.azure.resourcemanager.netapp.models.WeeklySchedule;
import java.io.IOException;

public final class SnapshotPolicyProperties
implements JsonSerializable<SnapshotPolicyProperties> {
    private HourlySchedule hourlySchedule;
    private DailySchedule dailySchedule;
    private WeeklySchedule weeklySchedule;
    private MonthlySchedule monthlySchedule;
    private Boolean enabled;
    private String provisioningState;

    public HourlySchedule hourlySchedule() {
        return this.hourlySchedule;
    }

    public SnapshotPolicyProperties withHourlySchedule(HourlySchedule hourlySchedule) {
        this.hourlySchedule = hourlySchedule;
        return this;
    }

    public DailySchedule dailySchedule() {
        return this.dailySchedule;
    }

    public SnapshotPolicyProperties withDailySchedule(DailySchedule dailySchedule) {
        this.dailySchedule = dailySchedule;
        return this;
    }

    public WeeklySchedule weeklySchedule() {
        return this.weeklySchedule;
    }

    public SnapshotPolicyProperties withWeeklySchedule(WeeklySchedule weeklySchedule) {
        this.weeklySchedule = weeklySchedule;
        return this;
    }

    public MonthlySchedule monthlySchedule() {
        return this.monthlySchedule;
    }

    public SnapshotPolicyProperties withMonthlySchedule(MonthlySchedule monthlySchedule) {
        this.monthlySchedule = monthlySchedule;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public SnapshotPolicyProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.hourlySchedule() != null) {
            this.hourlySchedule().validate();
        }
        if (this.dailySchedule() != null) {
            this.dailySchedule().validate();
        }
        if (this.weeklySchedule() != null) {
            this.weeklySchedule().validate();
        }
        if (this.monthlySchedule() != null) {
            this.monthlySchedule().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("hourlySchedule", (JsonSerializable)this.hourlySchedule);
        jsonWriter.writeJsonField("dailySchedule", (JsonSerializable)this.dailySchedule);
        jsonWriter.writeJsonField("weeklySchedule", (JsonSerializable)this.weeklySchedule);
        jsonWriter.writeJsonField("monthlySchedule", (JsonSerializable)this.monthlySchedule);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    public static SnapshotPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SnapshotPolicyProperties)jsonReader.readObject(reader -> {
            SnapshotPolicyProperties deserializedSnapshotPolicyProperties = new SnapshotPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("hourlySchedule".equals(fieldName)) {
                    deserializedSnapshotPolicyProperties.hourlySchedule = HourlySchedule.fromJson(reader);
                    continue;
                }
                if ("dailySchedule".equals(fieldName)) {
                    deserializedSnapshotPolicyProperties.dailySchedule = DailySchedule.fromJson(reader);
                    continue;
                }
                if ("weeklySchedule".equals(fieldName)) {
                    deserializedSnapshotPolicyProperties.weeklySchedule = WeeklySchedule.fromJson(reader);
                    continue;
                }
                if ("monthlySchedule".equals(fieldName)) {
                    deserializedSnapshotPolicyProperties.monthlySchedule = MonthlySchedule.fromJson(reader);
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedSnapshotPolicyProperties.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSnapshotPolicyProperties.provisioningState = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSnapshotPolicyProperties;
        });
    }
}

