/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.NetworkFeatures;
import com.azure.resourcemanager.netapp.models.NetworkSiblingSetProvisioningState;
import com.azure.resourcemanager.netapp.models.NicInfo;
import java.io.IOException;
import java.util.List;

public final class NetworkSiblingSetInner
implements JsonSerializable<NetworkSiblingSetInner> {
    private String networkSiblingSetId;
    private String subnetId;
    private String networkSiblingSetStateId;
    private NetworkFeatures networkFeatures;
    private NetworkSiblingSetProvisioningState provisioningState;
    private List<NicInfo> nicInfoList;

    public String networkSiblingSetId() {
        return this.networkSiblingSetId;
    }

    public NetworkSiblingSetInner withNetworkSiblingSetId(String networkSiblingSetId) {
        this.networkSiblingSetId = networkSiblingSetId;
        return this;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public NetworkSiblingSetInner withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String networkSiblingSetStateId() {
        return this.networkSiblingSetStateId;
    }

    public NetworkSiblingSetInner withNetworkSiblingSetStateId(String networkSiblingSetStateId) {
        this.networkSiblingSetStateId = networkSiblingSetStateId;
        return this;
    }

    public NetworkFeatures networkFeatures() {
        return this.networkFeatures;
    }

    public NetworkSiblingSetInner withNetworkFeatures(NetworkFeatures networkFeatures) {
        this.networkFeatures = networkFeatures;
        return this;
    }

    public NetworkSiblingSetProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<NicInfo> nicInfoList() {
        return this.nicInfoList;
    }

    public NetworkSiblingSetInner withNicInfoList(List<NicInfo> nicInfoList) {
        this.nicInfoList = nicInfoList;
        return this;
    }

    public void validate() {
        if (this.nicInfoList() != null) {
            this.nicInfoList().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("networkSiblingSetId", this.networkSiblingSetId);
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeStringField("networkSiblingSetStateId", this.networkSiblingSetStateId);
        jsonWriter.writeStringField("networkFeatures", this.networkFeatures == null ? null : this.networkFeatures.toString());
        jsonWriter.writeArrayField("nicInfoList", this.nicInfoList, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkSiblingSetInner fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSiblingSetInner)jsonReader.readObject(reader -> {
            NetworkSiblingSetInner deserializedNetworkSiblingSetInner = new NetworkSiblingSetInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("networkSiblingSetId".equals(fieldName)) {
                    deserializedNetworkSiblingSetInner.networkSiblingSetId = reader.getString();
                    continue;
                }
                if ("subnetId".equals(fieldName)) {
                    deserializedNetworkSiblingSetInner.subnetId = reader.getString();
                    continue;
                }
                if ("networkSiblingSetStateId".equals(fieldName)) {
                    deserializedNetworkSiblingSetInner.networkSiblingSetStateId = reader.getString();
                    continue;
                }
                if ("networkFeatures".equals(fieldName)) {
                    deserializedNetworkSiblingSetInner.networkFeatures = NetworkFeatures.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkSiblingSetInner.provisioningState = NetworkSiblingSetProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("nicInfoList".equals(fieldName)) {
                    List nicInfoList;
                    deserializedNetworkSiblingSetInner.nicInfoList = nicInfoList = reader.readArray(reader1 -> NicInfo.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSiblingSetInner;
        });
    }
}

