/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.VolumeBackups;
import java.io.IOException;
import java.util.List;

public final class BackupPolicyProperties
implements JsonSerializable<BackupPolicyProperties> {
    private String backupPolicyId;
    private String provisioningState;
    private Integer dailyBackupsToKeep;
    private Integer weeklyBackupsToKeep;
    private Integer monthlyBackupsToKeep;
    private Integer volumesAssigned;
    private Boolean enabled;
    private List<VolumeBackups> volumeBackups;

    public String backupPolicyId() {
        return this.backupPolicyId;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Integer dailyBackupsToKeep() {
        return this.dailyBackupsToKeep;
    }

    public BackupPolicyProperties withDailyBackupsToKeep(Integer dailyBackupsToKeep) {
        this.dailyBackupsToKeep = dailyBackupsToKeep;
        return this;
    }

    public Integer weeklyBackupsToKeep() {
        return this.weeklyBackupsToKeep;
    }

    public BackupPolicyProperties withWeeklyBackupsToKeep(Integer weeklyBackupsToKeep) {
        this.weeklyBackupsToKeep = weeklyBackupsToKeep;
        return this;
    }

    public Integer monthlyBackupsToKeep() {
        return this.monthlyBackupsToKeep;
    }

    public BackupPolicyProperties withMonthlyBackupsToKeep(Integer monthlyBackupsToKeep) {
        this.monthlyBackupsToKeep = monthlyBackupsToKeep;
        return this;
    }

    public Integer volumesAssigned() {
        return this.volumesAssigned;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public BackupPolicyProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<VolumeBackups> volumeBackups() {
        return this.volumeBackups;
    }

    public void validate() {
        if (this.volumeBackups() != null) {
            this.volumeBackups().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("dailyBackupsToKeep", (Number)this.dailyBackupsToKeep);
        jsonWriter.writeNumberField("weeklyBackupsToKeep", (Number)this.weeklyBackupsToKeep);
        jsonWriter.writeNumberField("monthlyBackupsToKeep", (Number)this.monthlyBackupsToKeep);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    public static BackupPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BackupPolicyProperties)jsonReader.readObject(reader -> {
            BackupPolicyProperties deserializedBackupPolicyProperties = new BackupPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("backupPolicyId".equals(fieldName)) {
                    deserializedBackupPolicyProperties.backupPolicyId = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBackupPolicyProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("dailyBackupsToKeep".equals(fieldName)) {
                    deserializedBackupPolicyProperties.dailyBackupsToKeep = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("weeklyBackupsToKeep".equals(fieldName)) {
                    deserializedBackupPolicyProperties.weeklyBackupsToKeep = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("monthlyBackupsToKeep".equals(fieldName)) {
                    deserializedBackupPolicyProperties.monthlyBackupsToKeep = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("volumesAssigned".equals(fieldName)) {
                    deserializedBackupPolicyProperties.volumesAssigned = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedBackupPolicyProperties.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("volumeBackups".equals(fieldName)) {
                    List volumeBackups;
                    deserializedBackupPolicyProperties.volumeBackups = volumeBackups = reader.readArray(reader1 -> VolumeBackups.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupPolicyProperties;
        });
    }
}

