/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.neonpostgres.models.Attributes;
import com.azure.resourcemanager.neonpostgres.models.ResourceProvisioningState;
import java.io.IOException;
import java.util.List;

public final class NeonRoleProperties
implements JsonSerializable<NeonRoleProperties> {
    private String entityId;
    private String entityName;
    private String createdAt;
    private ResourceProvisioningState provisioningState;
    private List<Attributes> attributes;
    private String branchId;
    private List<String> permissions;
    private Boolean isSuperUser;

    public String entityId() {
        return this.entityId;
    }

    public String entityName() {
        return this.entityName;
    }

    public NeonRoleProperties withEntityName(String entityName) {
        this.entityName = entityName;
        return this;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public ResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<Attributes> attributes() {
        return this.attributes;
    }

    public NeonRoleProperties withAttributes(List<Attributes> attributes) {
        this.attributes = attributes;
        return this;
    }

    public String branchId() {
        return this.branchId;
    }

    public NeonRoleProperties withBranchId(String branchId) {
        this.branchId = branchId;
        return this;
    }

    public List<String> permissions() {
        return this.permissions;
    }

    public NeonRoleProperties withPermissions(List<String> permissions) {
        this.permissions = permissions;
        return this;
    }

    public Boolean isSuperUser() {
        return this.isSuperUser;
    }

    public NeonRoleProperties withIsSuperUser(Boolean isSuperUser) {
        this.isSuperUser = isSuperUser;
        return this;
    }

    public void validate() {
        if (this.attributes() != null) {
            this.attributes().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("entityName", this.entityName);
        jsonWriter.writeArrayField("attributes", this.attributes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("branchId", this.branchId);
        jsonWriter.writeArrayField("permissions", this.permissions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isSuperUser", this.isSuperUser);
        return jsonWriter.writeEndObject();
    }

    public static NeonRoleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NeonRoleProperties)jsonReader.readObject(reader -> {
            NeonRoleProperties deserializedNeonRoleProperties = new NeonRoleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("entityId".equals(fieldName)) {
                    deserializedNeonRoleProperties.entityId = reader.getString();
                    continue;
                }
                if ("entityName".equals(fieldName)) {
                    deserializedNeonRoleProperties.entityName = reader.getString();
                    continue;
                }
                if ("createdAt".equals(fieldName)) {
                    deserializedNeonRoleProperties.createdAt = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedNeonRoleProperties.provisioningState = ResourceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    List attributes;
                    deserializedNeonRoleProperties.attributes = attributes = reader.readArray(reader1 -> Attributes.fromJson(reader1));
                    continue;
                }
                if ("branchId".equals(fieldName)) {
                    deserializedNeonRoleProperties.branchId = reader.getString();
                    continue;
                }
                if ("permissions".equals(fieldName)) {
                    List permissions;
                    deserializedNeonRoleProperties.permissions = permissions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("isSuperUser".equals(fieldName)) {
                    deserializedNeonRoleProperties.isSuperUser = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNeonRoleProperties;
        });
    }
}

