/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.neonpostgres.models.MarketplaceSubscriptionStatus;
import com.azure.resourcemanager.neonpostgres.models.OfferDetails;
import java.io.IOException;

public final class MarketplaceDetails
implements JsonSerializable<MarketplaceDetails> {
    private String subscriptionId;
    private MarketplaceSubscriptionStatus subscriptionStatus;
    private OfferDetails offerDetails;
    private static final ClientLogger LOGGER = new ClientLogger(MarketplaceDetails.class);

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public MarketplaceDetails withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public MarketplaceSubscriptionStatus subscriptionStatus() {
        return this.subscriptionStatus;
    }

    public MarketplaceDetails withSubscriptionStatus(MarketplaceSubscriptionStatus subscriptionStatus) {
        this.subscriptionStatus = subscriptionStatus;
        return this;
    }

    public OfferDetails offerDetails() {
        return this.offerDetails;
    }

    public MarketplaceDetails withOfferDetails(OfferDetails offerDetails) {
        this.offerDetails = offerDetails;
        return this;
    }

    public void validate() {
        if (this.offerDetails() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property offerDetails in model MarketplaceDetails"));
        }
        this.offerDetails().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("offerDetails", (JsonSerializable)this.offerDetails);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("subscriptionStatus", this.subscriptionStatus == null ? null : this.subscriptionStatus.toString());
        return jsonWriter.writeEndObject();
    }

    public static MarketplaceDetails fromJson(JsonReader jsonReader) throws IOException {
        return (MarketplaceDetails)jsonReader.readObject(reader -> {
            MarketplaceDetails deserializedMarketplaceDetails = new MarketplaceDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("offerDetails".equals(fieldName)) {
                    deserializedMarketplaceDetails.offerDetails = OfferDetails.fromJson(reader);
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedMarketplaceDetails.subscriptionId = reader.getString();
                    continue;
                }
                if ("subscriptionStatus".equals(fieldName)) {
                    deserializedMarketplaceDetails.subscriptionStatus = MarketplaceSubscriptionStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMarketplaceDetails;
        });
    }
}

