/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.neonpostgres.models.Attributes;
import com.azure.resourcemanager.neonpostgres.models.EndpointType;
import com.azure.resourcemanager.neonpostgres.models.ResourceProvisioningState;
import java.io.IOException;
import java.util.List;

public final class EndpointProperties
implements JsonSerializable<EndpointProperties> {
    private String entityId;
    private String entityName;
    private String createdAt;
    private ResourceProvisioningState provisioningState;
    private List<Attributes> attributes;
    private String projectId;
    private String branchId;
    private EndpointType endpointType;

    public String entityId() {
        return this.entityId;
    }

    public String entityName() {
        return this.entityName;
    }

    public EndpointProperties withEntityName(String entityName) {
        this.entityName = entityName;
        return this;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public ResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<Attributes> attributes() {
        return this.attributes;
    }

    public EndpointProperties withAttributes(List<Attributes> attributes) {
        this.attributes = attributes;
        return this;
    }

    public String projectId() {
        return this.projectId;
    }

    public EndpointProperties withProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public String branchId() {
        return this.branchId;
    }

    public EndpointProperties withBranchId(String branchId) {
        this.branchId = branchId;
        return this;
    }

    public EndpointType endpointType() {
        return this.endpointType;
    }

    public EndpointProperties withEndpointType(EndpointType endpointType) {
        this.endpointType = endpointType;
        return this;
    }

    public void validate() {
        if (this.attributes() != null) {
            this.attributes().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("entityName", this.entityName);
        jsonWriter.writeArrayField("attributes", this.attributes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("projectId", this.projectId);
        jsonWriter.writeStringField("branchId", this.branchId);
        jsonWriter.writeStringField("endpointType", this.endpointType == null ? null : this.endpointType.toString());
        return jsonWriter.writeEndObject();
    }

    public static EndpointProperties fromJson(JsonReader jsonReader) throws IOException {
        return (EndpointProperties)jsonReader.readObject(reader -> {
            EndpointProperties deserializedEndpointProperties = new EndpointProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("entityId".equals(fieldName)) {
                    deserializedEndpointProperties.entityId = reader.getString();
                    continue;
                }
                if ("entityName".equals(fieldName)) {
                    deserializedEndpointProperties.entityName = reader.getString();
                    continue;
                }
                if ("createdAt".equals(fieldName)) {
                    deserializedEndpointProperties.createdAt = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedEndpointProperties.provisioningState = ResourceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    List attributes;
                    deserializedEndpointProperties.attributes = attributes = reader.readArray(reader1 -> Attributes.fromJson(reader1));
                    continue;
                }
                if ("projectId".equals(fieldName)) {
                    deserializedEndpointProperties.projectId = reader.getString();
                    continue;
                }
                if ("branchId".equals(fieldName)) {
                    deserializedEndpointProperties.branchId = reader.getString();
                    continue;
                }
                if ("endpointType".equals(fieldName)) {
                    deserializedEndpointProperties.endpointType = EndpointType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEndpointProperties;
        });
    }
}

