/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.neonpostgres.models.Attributes;
import com.azure.resourcemanager.neonpostgres.models.EndpointProperties;
import com.azure.resourcemanager.neonpostgres.models.NeonDatabaseProperties;
import com.azure.resourcemanager.neonpostgres.models.NeonRoleProperties;
import com.azure.resourcemanager.neonpostgres.models.ResourceProvisioningState;
import java.io.IOException;
import java.util.List;

public final class BranchProperties
implements JsonSerializable<BranchProperties> {
    private String entityId;
    private String entityName;
    private String createdAt;
    private ResourceProvisioningState provisioningState;
    private List<Attributes> attributes;
    private String projectId;
    private String parentId;
    private String roleName;
    private String databaseName;
    private List<NeonRoleProperties> roles;
    private List<NeonDatabaseProperties> databases;
    private List<EndpointProperties> endpoints;

    public String entityId() {
        return this.entityId;
    }

    public String entityName() {
        return this.entityName;
    }

    public BranchProperties withEntityName(String entityName) {
        this.entityName = entityName;
        return this;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public ResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<Attributes> attributes() {
        return this.attributes;
    }

    public BranchProperties withAttributes(List<Attributes> attributes) {
        this.attributes = attributes;
        return this;
    }

    public String projectId() {
        return this.projectId;
    }

    public BranchProperties withProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public String parentId() {
        return this.parentId;
    }

    public BranchProperties withParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public String roleName() {
        return this.roleName;
    }

    public BranchProperties withRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public BranchProperties withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public List<NeonRoleProperties> roles() {
        return this.roles;
    }

    public BranchProperties withRoles(List<NeonRoleProperties> roles) {
        this.roles = roles;
        return this;
    }

    public List<NeonDatabaseProperties> databases() {
        return this.databases;
    }

    public BranchProperties withDatabases(List<NeonDatabaseProperties> databases) {
        this.databases = databases;
        return this;
    }

    public List<EndpointProperties> endpoints() {
        return this.endpoints;
    }

    public BranchProperties withEndpoints(List<EndpointProperties> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public void validate() {
        if (this.attributes() != null) {
            this.attributes().forEach(e -> e.validate());
        }
        if (this.roles() != null) {
            this.roles().forEach(e -> e.validate());
        }
        if (this.databases() != null) {
            this.databases().forEach(e -> e.validate());
        }
        if (this.endpoints() != null) {
            this.endpoints().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("entityName", this.entityName);
        jsonWriter.writeArrayField("attributes", this.attributes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("projectId", this.projectId);
        jsonWriter.writeStringField("parentId", this.parentId);
        jsonWriter.writeStringField("roleName", this.roleName);
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeArrayField("roles", this.roles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("databases", this.databases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("endpoints", this.endpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BranchProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BranchProperties)jsonReader.readObject(reader -> {
            BranchProperties deserializedBranchProperties = new BranchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("entityId".equals(fieldName)) {
                    deserializedBranchProperties.entityId = reader.getString();
                    continue;
                }
                if ("entityName".equals(fieldName)) {
                    deserializedBranchProperties.entityName = reader.getString();
                    continue;
                }
                if ("createdAt".equals(fieldName)) {
                    deserializedBranchProperties.createdAt = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBranchProperties.provisioningState = ResourceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    List attributes;
                    deserializedBranchProperties.attributes = attributes = reader.readArray(reader1 -> Attributes.fromJson(reader1));
                    continue;
                }
                if ("projectId".equals(fieldName)) {
                    deserializedBranchProperties.projectId = reader.getString();
                    continue;
                }
                if ("parentId".equals(fieldName)) {
                    deserializedBranchProperties.parentId = reader.getString();
                    continue;
                }
                if ("roleName".equals(fieldName)) {
                    deserializedBranchProperties.roleName = reader.getString();
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedBranchProperties.databaseName = reader.getString();
                    continue;
                }
                if ("roles".equals(fieldName)) {
                    List roles;
                    deserializedBranchProperties.roles = roles = reader.readArray(reader1 -> NeonRoleProperties.fromJson(reader1));
                    continue;
                }
                if ("databases".equals(fieldName)) {
                    List databases;
                    deserializedBranchProperties.databases = databases = reader.readArray(reader1 -> NeonDatabaseProperties.fromJson(reader1));
                    continue;
                }
                if ("endpoints".equals(fieldName)) {
                    List endpoints;
                    deserializedBranchProperties.endpoints = endpoints = reader.readArray(reader1 -> EndpointProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBranchProperties;
        });
    }
}

