/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.neonpostgres.fluent.models.ComputeInner;
import java.io.IOException;
import java.util.List;

public final class ComputeListResult
implements JsonSerializable<ComputeListResult> {
    private List<ComputeInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ComputeListResult.class);

    private ComputeListResult() {
    }

    public List<ComputeInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ComputeListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ComputeListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ComputeListResult)jsonReader.readObject(reader -> {
            ComputeListResult deserializedComputeListResult = new ComputeListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedComputeListResult.value = value = reader.readArray(reader1 -> ComputeInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedComputeListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedComputeListResult;
        });
    }
}

