/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.neonpostgres.fluent.models.BranchInner;
import java.io.IOException;
import java.util.List;

public final class BranchListResult
implements JsonSerializable<BranchListResult> {
    private List<BranchInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(BranchListResult.class);

    private BranchListResult() {
    }

    public List<BranchInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model BranchListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static BranchListResult fromJson(JsonReader jsonReader) throws IOException {
        return (BranchListResult)jsonReader.readObject(reader -> {
            BranchListResult deserializedBranchListResult = new BranchListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedBranchListResult.value = value = reader.readArray(reader1 -> BranchInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedBranchListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBranchListResult;
        });
    }
}

