/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.neonpostgres.NeonPostgresManager;
import com.azure.resourcemanager.neonpostgres.fluent.ProjectsClient;
import com.azure.resourcemanager.neonpostgres.fluent.models.ConnectionUriPropertiesInner;
import com.azure.resourcemanager.neonpostgres.fluent.models.ProjectInner;
import com.azure.resourcemanager.neonpostgres.implementation.ConnectionUriPropertiesImpl;
import com.azure.resourcemanager.neonpostgres.implementation.ProjectImpl;
import com.azure.resourcemanager.neonpostgres.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.neonpostgres.models.ConnectionUriProperties;
import com.azure.resourcemanager.neonpostgres.models.Project;
import com.azure.resourcemanager.neonpostgres.models.Projects;

public final class ProjectsImpl
implements Projects {
    private static final ClientLogger LOGGER = new ClientLogger(ProjectsImpl.class);
    private final ProjectsClient innerClient;
    private final NeonPostgresManager serviceManager;

    public ProjectsImpl(ProjectsClient innerClient, NeonPostgresManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Project> getWithResponse(String resourceGroupName, String organizationName, String projectName, Context context) {
        Response<ProjectInner> inner = this.serviceClient().getWithResponse(resourceGroupName, organizationName, projectName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ProjectImpl((ProjectInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Project get(String resourceGroupName, String organizationName, String projectName) {
        ProjectInner inner = this.serviceClient().get(resourceGroupName, organizationName, projectName);
        if (inner != null) {
            return new ProjectImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String organizationName, String projectName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, organizationName, projectName, context);
    }

    @Override
    public void delete(String resourceGroupName, String organizationName, String projectName) {
        this.serviceClient().delete(resourceGroupName, organizationName, projectName);
    }

    @Override
    public PagedIterable<Project> list(String resourceGroupName, String organizationName) {
        PagedIterable<ProjectInner> inner = this.serviceClient().list(resourceGroupName, organizationName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProjectImpl((ProjectInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Project> list(String resourceGroupName, String organizationName, Context context) {
        PagedIterable<ProjectInner> inner = this.serviceClient().list(resourceGroupName, organizationName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProjectImpl((ProjectInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ConnectionUriProperties> getConnectionUriWithResponse(String resourceGroupName, String organizationName, String projectName, ConnectionUriPropertiesInner connectionUriParameters, Context context) {
        Response<ConnectionUriPropertiesInner> inner = this.serviceClient().getConnectionUriWithResponse(resourceGroupName, organizationName, projectName, connectionUriParameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConnectionUriPropertiesImpl((ConnectionUriPropertiesInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ConnectionUriProperties getConnectionUri(String resourceGroupName, String organizationName, String projectName, ConnectionUriPropertiesInner connectionUriParameters) {
        ConnectionUriPropertiesInner inner = this.serviceClient().getConnectionUri(resourceGroupName, organizationName, projectName, connectionUriParameters);
        if (inner != null) {
            return new ConnectionUriPropertiesImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Project getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        return (Project)this.getWithResponse(resourceGroupName, organizationName, projectName, Context.NONE).getValue();
    }

    @Override
    public Response<Project> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        return this.getWithResponse(resourceGroupName, organizationName, projectName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, organizationName, projectName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, organizationName, projectName, context);
    }

    private ProjectsClient serviceClient() {
        return this.innerClient;
    }

    private NeonPostgresManager manager() {
        return this.serviceManager;
    }

    @Override
    public ProjectImpl define(String name) {
        return new ProjectImpl(name, this.manager());
    }
}

