/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.neonpostgres.NeonPostgresManager;
import com.azure.resourcemanager.neonpostgres.fluent.OrganizationsClient;
import com.azure.resourcemanager.neonpostgres.fluent.models.OrganizationResourceInner;
import com.azure.resourcemanager.neonpostgres.fluent.models.PgVersionsResultInner;
import com.azure.resourcemanager.neonpostgres.implementation.OrganizationResourceImpl;
import com.azure.resourcemanager.neonpostgres.implementation.PgVersionsResultImpl;
import com.azure.resourcemanager.neonpostgres.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.neonpostgres.models.OrganizationResource;
import com.azure.resourcemanager.neonpostgres.models.Organizations;
import com.azure.resourcemanager.neonpostgres.models.PgVersion;
import com.azure.resourcemanager.neonpostgres.models.PgVersionsResult;

public final class OrganizationsImpl
implements Organizations {
    private static final ClientLogger LOGGER = new ClientLogger(OrganizationsImpl.class);
    private final OrganizationsClient innerClient;
    private final NeonPostgresManager serviceManager;

    public OrganizationsImpl(OrganizationsClient innerClient, NeonPostgresManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<OrganizationResource> getByResourceGroupWithResponse(String resourceGroupName, String organizationName, Context context) {
        Response<OrganizationResourceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, organizationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OrganizationResourceImpl((OrganizationResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public OrganizationResource getByResourceGroup(String resourceGroupName, String organizationName) {
        OrganizationResourceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, organizationName);
        if (inner != null) {
            return new OrganizationResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String organizationName) {
        this.serviceClient().delete(resourceGroupName, organizationName);
    }

    @Override
    public void delete(String resourceGroupName, String organizationName, Context context) {
        this.serviceClient().delete(resourceGroupName, organizationName, context);
    }

    @Override
    public PagedIterable<OrganizationResource> listByResourceGroup(String resourceGroupName) {
        PagedIterable<OrganizationResourceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OrganizationResourceImpl((OrganizationResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<OrganizationResource> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<OrganizationResourceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OrganizationResourceImpl((OrganizationResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<OrganizationResource> list() {
        PagedIterable<OrganizationResourceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OrganizationResourceImpl((OrganizationResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<OrganizationResource> list(Context context) {
        PagedIterable<OrganizationResourceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OrganizationResourceImpl((OrganizationResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<PgVersionsResult> getPostgresVersionsWithResponse(String resourceGroupName, PgVersion parameters, Context context) {
        Response<PgVersionsResultInner> inner = this.serviceClient().getPostgresVersionsWithResponse(resourceGroupName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PgVersionsResultImpl((PgVersionsResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PgVersionsResult getPostgresVersions(String resourceGroupName) {
        PgVersionsResultInner inner = this.serviceClient().getPostgresVersions(resourceGroupName);
        if (inner != null) {
            return new PgVersionsResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OrganizationResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        return (OrganizationResource)this.getByResourceGroupWithResponse(resourceGroupName, organizationName, Context.NONE).getValue();
    }

    @Override
    public Response<OrganizationResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, organizationName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        this.delete(resourceGroupName, organizationName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        this.delete(resourceGroupName, organizationName, context);
    }

    private OrganizationsClient serviceClient() {
        return this.innerClient;
    }

    private NeonPostgresManager manager() {
        return this.serviceManager;
    }

    @Override
    public OrganizationResourceImpl define(String name) {
        return new OrganizationResourceImpl(name, this.manager());
    }
}

