/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.neonpostgres.NeonPostgresManager;
import com.azure.resourcemanager.neonpostgres.fluent.models.NeonRoleInner;
import com.azure.resourcemanager.neonpostgres.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.neonpostgres.models.NeonRole;
import com.azure.resourcemanager.neonpostgres.models.NeonRoleProperties;

public final class NeonRoleImpl
implements NeonRole,
NeonRole.Definition,
NeonRole.Update {
    private NeonRoleInner innerObject;
    private final NeonPostgresManager serviceManager;
    private String resourceGroupName;
    private String organizationName;
    private String projectName;
    private String branchName;
    private String neonRoleName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public NeonRoleProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public NeonRoleInner innerModel() {
        return this.innerObject;
    }

    private NeonPostgresManager manager() {
        return this.serviceManager;
    }

    @Override
    public NeonRoleImpl withExistingBranche(String resourceGroupName, String organizationName, String projectName, String branchName) {
        this.resourceGroupName = resourceGroupName;
        this.organizationName = organizationName;
        this.projectName = projectName;
        this.branchName = branchName;
        return this;
    }

    @Override
    public NeonRole create() {
        this.innerObject = this.serviceManager.serviceClient().getNeonRoles().createOrUpdate(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.neonRoleName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public NeonRole create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNeonRoles().createOrUpdate(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.neonRoleName, this.innerModel(), context);
        return this;
    }

    NeonRoleImpl(String name, NeonPostgresManager serviceManager) {
        this.innerObject = new NeonRoleInner();
        this.serviceManager = serviceManager;
        this.neonRoleName = name;
    }

    @Override
    public NeonRoleImpl update() {
        return this;
    }

    @Override
    public NeonRole apply() {
        this.innerObject = this.serviceManager.serviceClient().getNeonRoles().update(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.neonRoleName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public NeonRole apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNeonRoles().update(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.neonRoleName, this.innerModel(), context);
        return this;
    }

    NeonRoleImpl(NeonRoleInner innerObject, NeonPostgresManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.organizationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "organizations");
        this.projectName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "projects");
        this.branchName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "branches");
        this.neonRoleName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "neonRoles");
    }

    @Override
    public NeonRole refresh() {
        this.innerObject = (NeonRoleInner)((Object)this.serviceManager.serviceClient().getNeonRoles().getWithResponse(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.neonRoleName, Context.NONE).getValue());
        return this;
    }

    @Override
    public NeonRole refresh(Context context) {
        this.innerObject = (NeonRoleInner)((Object)this.serviceManager.serviceClient().getNeonRoles().getWithResponse(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.neonRoleName, context).getValue());
        return this;
    }

    @Override
    public NeonRoleImpl withProperties(NeonRoleProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

