/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.neonpostgres.NeonPostgresManager;
import com.azure.resourcemanager.neonpostgres.fluent.NeonDatabasesClient;
import com.azure.resourcemanager.neonpostgres.fluent.models.NeonDatabaseInner;
import com.azure.resourcemanager.neonpostgres.implementation.NeonDatabaseImpl;
import com.azure.resourcemanager.neonpostgres.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.neonpostgres.models.NeonDatabase;
import com.azure.resourcemanager.neonpostgres.models.NeonDatabases;

public final class NeonDatabasesImpl
implements NeonDatabases {
    private static final ClientLogger LOGGER = new ClientLogger(NeonDatabasesImpl.class);
    private final NeonDatabasesClient innerClient;
    private final NeonPostgresManager serviceManager;

    public NeonDatabasesImpl(NeonDatabasesClient innerClient, NeonPostgresManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<NeonDatabase> getWithResponse(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, Context context) {
        Response<NeonDatabaseInner> inner = this.serviceClient().getWithResponse(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NeonDatabaseImpl((NeonDatabaseInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public NeonDatabase get(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName) {
        NeonDatabaseInner inner = this.serviceClient().get(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName);
        if (inner != null) {
            return new NeonDatabaseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, context);
    }

    @Override
    public void delete(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName) {
        this.serviceClient().delete(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName);
    }

    @Override
    public PagedIterable<NeonDatabase> list(String resourceGroupName, String organizationName, String projectName, String branchName) {
        PagedIterable<NeonDatabaseInner> inner = this.serviceClient().list(resourceGroupName, organizationName, projectName, branchName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NeonDatabaseImpl((NeonDatabaseInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<NeonDatabase> list(String resourceGroupName, String organizationName, String projectName, String branchName, Context context) {
        PagedIterable<NeonDatabaseInner> inner = this.serviceClient().list(resourceGroupName, organizationName, projectName, branchName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NeonDatabaseImpl((NeonDatabaseInner)((Object)inner1), this.manager()));
    }

    @Override
    public NeonDatabase getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        String neonDatabaseName = ResourceManagerUtils.getValueFromIdByName(id, "neonDatabases");
        if (neonDatabaseName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'neonDatabases'.", id)));
        }
        return (NeonDatabase)this.getWithResponse(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, Context.NONE).getValue();
    }

    @Override
    public Response<NeonDatabase> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        String neonDatabaseName = ResourceManagerUtils.getValueFromIdByName(id, "neonDatabases");
        if (neonDatabaseName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'neonDatabases'.", id)));
        }
        return this.getWithResponse(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        String neonDatabaseName = ResourceManagerUtils.getValueFromIdByName(id, "neonDatabases");
        if (neonDatabaseName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'neonDatabases'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        String neonDatabaseName = ResourceManagerUtils.getValueFromIdByName(id, "neonDatabases");
        if (neonDatabaseName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'neonDatabases'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, context);
    }

    private NeonDatabasesClient serviceClient() {
        return this.innerClient;
    }

    private NeonPostgresManager manager() {
        return this.serviceManager;
    }

    @Override
    public NeonDatabaseImpl define(String name) {
        return new NeonDatabaseImpl(name, this.manager());
    }
}

