/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.neonpostgres.NeonPostgresManager;
import com.azure.resourcemanager.neonpostgres.fluent.models.EndpointInner;
import com.azure.resourcemanager.neonpostgres.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.neonpostgres.models.Endpoint;
import com.azure.resourcemanager.neonpostgres.models.EndpointProperties;

public final class EndpointImpl
implements Endpoint,
Endpoint.Definition,
Endpoint.Update {
    private EndpointInner innerObject;
    private final NeonPostgresManager serviceManager;
    private String resourceGroupName;
    private String organizationName;
    private String projectName;
    private String branchName;
    private String endpointName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public EndpointProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public EndpointInner innerModel() {
        return this.innerObject;
    }

    private NeonPostgresManager manager() {
        return this.serviceManager;
    }

    @Override
    public EndpointImpl withExistingBranche(String resourceGroupName, String organizationName, String projectName, String branchName) {
        this.resourceGroupName = resourceGroupName;
        this.organizationName = organizationName;
        this.projectName = projectName;
        this.branchName = branchName;
        return this;
    }

    @Override
    public Endpoint create() {
        this.innerObject = this.serviceManager.serviceClient().getEndpoints().createOrUpdate(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.endpointName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Endpoint create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getEndpoints().createOrUpdate(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.endpointName, this.innerModel(), context);
        return this;
    }

    EndpointImpl(String name, NeonPostgresManager serviceManager) {
        this.innerObject = new EndpointInner();
        this.serviceManager = serviceManager;
        this.endpointName = name;
    }

    @Override
    public EndpointImpl update() {
        return this;
    }

    @Override
    public Endpoint apply() {
        this.innerObject = this.serviceManager.serviceClient().getEndpoints().update(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.endpointName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Endpoint apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getEndpoints().update(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.endpointName, this.innerModel(), context);
        return this;
    }

    EndpointImpl(EndpointInner innerObject, NeonPostgresManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.organizationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "organizations");
        this.projectName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "projects");
        this.branchName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "branches");
        this.endpointName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "endpoints");
    }

    @Override
    public Endpoint refresh() {
        this.innerObject = (EndpointInner)((Object)this.serviceManager.serviceClient().getEndpoints().getWithResponse(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.endpointName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Endpoint refresh(Context context) {
        this.innerObject = (EndpointInner)((Object)this.serviceManager.serviceClient().getEndpoints().getWithResponse(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.endpointName, context).getValue());
        return this;
    }

    @Override
    public EndpointImpl withProperties(EndpointProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

