/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.neonpostgres.NeonPostgresManager;
import com.azure.resourcemanager.neonpostgres.fluent.ComputesClient;
import com.azure.resourcemanager.neonpostgres.fluent.models.ComputeInner;
import com.azure.resourcemanager.neonpostgres.implementation.ComputeImpl;
import com.azure.resourcemanager.neonpostgres.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.neonpostgres.models.Compute;
import com.azure.resourcemanager.neonpostgres.models.Computes;

public final class ComputesImpl
implements Computes {
    private static final ClientLogger LOGGER = new ClientLogger(ComputesImpl.class);
    private final ComputesClient innerClient;
    private final NeonPostgresManager serviceManager;

    public ComputesImpl(ComputesClient innerClient, NeonPostgresManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Compute> getWithResponse(String resourceGroupName, String organizationName, String projectName, String branchName, String computeName, Context context) {
        Response<ComputeInner> inner = this.serviceClient().getWithResponse(resourceGroupName, organizationName, projectName, branchName, computeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ComputeImpl((ComputeInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Compute get(String resourceGroupName, String organizationName, String projectName, String branchName, String computeName) {
        ComputeInner inner = this.serviceClient().get(resourceGroupName, organizationName, projectName, branchName, computeName);
        if (inner != null) {
            return new ComputeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String organizationName, String projectName, String branchName, String computeName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, organizationName, projectName, branchName, computeName, context);
    }

    @Override
    public void delete(String resourceGroupName, String organizationName, String projectName, String branchName, String computeName) {
        this.serviceClient().delete(resourceGroupName, organizationName, projectName, branchName, computeName);
    }

    @Override
    public PagedIterable<Compute> list(String resourceGroupName, String organizationName, String projectName, String branchName) {
        PagedIterable<ComputeInner> inner = this.serviceClient().list(resourceGroupName, organizationName, projectName, branchName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ComputeImpl((ComputeInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Compute> list(String resourceGroupName, String organizationName, String projectName, String branchName, Context context) {
        PagedIterable<ComputeInner> inner = this.serviceClient().list(resourceGroupName, organizationName, projectName, branchName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ComputeImpl((ComputeInner)((Object)inner1), this.manager()));
    }

    @Override
    public Compute getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        String computeName = ResourceManagerUtils.getValueFromIdByName(id, "computes");
        if (computeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'computes'.", id)));
        }
        return (Compute)this.getWithResponse(resourceGroupName, organizationName, projectName, branchName, computeName, Context.NONE).getValue();
    }

    @Override
    public Response<Compute> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        String computeName = ResourceManagerUtils.getValueFromIdByName(id, "computes");
        if (computeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'computes'.", id)));
        }
        return this.getWithResponse(resourceGroupName, organizationName, projectName, branchName, computeName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        String computeName = ResourceManagerUtils.getValueFromIdByName(id, "computes");
        if (computeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'computes'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, organizationName, projectName, branchName, computeName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        String computeName = ResourceManagerUtils.getValueFromIdByName(id, "computes");
        if (computeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'computes'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, organizationName, projectName, branchName, computeName, context);
    }

    private ComputesClient serviceClient() {
        return this.innerClient;
    }

    private NeonPostgresManager manager() {
        return this.serviceManager;
    }

    @Override
    public ComputeImpl define(String name) {
        return new ComputeImpl(name, this.manager());
    }
}

