/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.neonpostgres.NeonPostgresManager;
import com.azure.resourcemanager.neonpostgres.fluent.models.BranchInner;
import com.azure.resourcemanager.neonpostgres.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.neonpostgres.models.Branch;
import com.azure.resourcemanager.neonpostgres.models.BranchProperties;

public final class BranchImpl
implements Branch,
Branch.Definition,
Branch.Update {
    private BranchInner innerObject;
    private final NeonPostgresManager serviceManager;
    private String resourceGroupName;
    private String organizationName;
    private String projectName;
    private String branchName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public BranchProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public BranchInner innerModel() {
        return this.innerObject;
    }

    private NeonPostgresManager manager() {
        return this.serviceManager;
    }

    @Override
    public BranchImpl withExistingProject(String resourceGroupName, String organizationName, String projectName) {
        this.resourceGroupName = resourceGroupName;
        this.organizationName = organizationName;
        this.projectName = projectName;
        return this;
    }

    @Override
    public Branch create() {
        this.innerObject = this.serviceManager.serviceClient().getBranches().createOrUpdate(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Branch create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBranches().createOrUpdate(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.innerModel(), context);
        return this;
    }

    BranchImpl(String name, NeonPostgresManager serviceManager) {
        this.innerObject = new BranchInner();
        this.serviceManager = serviceManager;
        this.branchName = name;
    }

    @Override
    public BranchImpl update() {
        return this;
    }

    @Override
    public Branch apply() {
        this.innerObject = this.serviceManager.serviceClient().getBranches().update(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Branch apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBranches().update(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.innerModel(), context);
        return this;
    }

    BranchImpl(BranchInner innerObject, NeonPostgresManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.organizationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "organizations");
        this.projectName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "projects");
        this.branchName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "branches");
    }

    @Override
    public Branch refresh() {
        this.innerObject = (BranchInner)((Object)this.serviceManager.serviceClient().getBranches().getWithResponse(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Branch refresh(Context context) {
        this.innerObject = (BranchInner)((Object)this.serviceManager.serviceClient().getBranches().getWithResponse(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, context).getValue());
        return this;
    }

    @Override
    public BranchImpl withProperties(BranchProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

