/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.neonpostgres.models.ProjectProperties;
import java.io.IOException;

public final class ProjectInner
extends ProxyResource {
    private ProjectProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public ProjectProperties properties() {
        return this.properties;
    }

    public ProjectInner withProperties(ProjectProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ProjectInner fromJson(JsonReader jsonReader) throws IOException {
        return (ProjectInner)((Object)jsonReader.readObject(reader -> {
            ProjectInner deserializedProjectInner = new ProjectInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedProjectInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedProjectInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedProjectInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedProjectInner.properties = ProjectProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedProjectInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProjectInner;
        }));
    }
}

