/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.msi.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.msi.fluent.FederatedIdentityCredentialsClient;
import com.azure.resourcemanager.msi.fluent.ManagedServiceIdentityClient;
import com.azure.resourcemanager.msi.fluent.OperationsClient;
import com.azure.resourcemanager.msi.fluent.SystemAssignedIdentitiesClient;
import com.azure.resourcemanager.msi.fluent.UserAssignedIdentitiesClient;
import com.azure.resourcemanager.msi.implementation.FederatedIdentityCredentialsClientImpl;
import com.azure.resourcemanager.msi.implementation.ManagedServiceIdentityClientBuilder;
import com.azure.resourcemanager.msi.implementation.OperationsClientImpl;
import com.azure.resourcemanager.msi.implementation.SystemAssignedIdentitiesClientImpl;
import com.azure.resourcemanager.msi.implementation.UserAssignedIdentitiesClientImpl;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;

@ServiceClient(builder=ManagedServiceIdentityClientBuilder.class)
public final class ManagedServiceIdentityClientImpl
extends AzureServiceClient
implements ManagedServiceIdentityClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final SystemAssignedIdentitiesClient systemAssignedIdentities;
    private final OperationsClient operations;
    private final UserAssignedIdentitiesClient userAssignedIdentities;
    private final FederatedIdentityCredentialsClient federatedIdentityCredentials;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public SystemAssignedIdentitiesClient getSystemAssignedIdentities() {
        return this.systemAssignedIdentities;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public UserAssignedIdentitiesClient getUserAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    @Override
    public FederatedIdentityCredentialsClient getFederatedIdentityCredentials() {
        return this.federatedIdentityCredentials;
    }

    ManagedServiceIdentityClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2023-01-31";
        this.systemAssignedIdentities = new SystemAssignedIdentitiesClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.userAssignedIdentities = new UserAssignedIdentitiesClientImpl(this);
        this.federatedIdentityCredentials = new FederatedIdentityCredentialsClientImpl(this);
    }
}

