/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mongodbatlas.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class PartnerProperties
implements JsonSerializable<PartnerProperties> {
    private String organizationId;
    private String redirectUrl;
    private String organizationName;
    private static final ClientLogger LOGGER = new ClientLogger(PartnerProperties.class);

    public String organizationId() {
        return this.organizationId;
    }

    public PartnerProperties withOrganizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    public String redirectUrl() {
        return this.redirectUrl;
    }

    public PartnerProperties withRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    public String organizationName() {
        return this.organizationName;
    }

    public PartnerProperties withOrganizationName(String organizationName) {
        this.organizationName = organizationName;
        return this;
    }

    public void validate() {
        if (this.organizationName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property organizationName in model PartnerProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("organizationName", this.organizationName);
        jsonWriter.writeStringField("organizationId", this.organizationId);
        jsonWriter.writeStringField("redirectUrl", this.redirectUrl);
        return jsonWriter.writeEndObject();
    }

    public static PartnerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PartnerProperties)jsonReader.readObject(reader -> {
            PartnerProperties deserializedPartnerProperties = new PartnerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("organizationName".equals(fieldName)) {
                    deserializedPartnerProperties.organizationName = reader.getString();
                    continue;
                }
                if ("organizationId".equals(fieldName)) {
                    deserializedPartnerProperties.organizationId = reader.getString();
                    continue;
                }
                if ("redirectUrl".equals(fieldName)) {
                    deserializedPartnerProperties.redirectUrl = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartnerProperties;
        });
    }
}

