/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mongodbatlas.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.mongodbatlas.fluent.models.OrganizationResourceInner;
import java.io.IOException;
import java.util.List;

public final class OrganizationResourceListResult
implements JsonSerializable<OrganizationResourceListResult> {
    private List<OrganizationResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(OrganizationResourceListResult.class);

    private OrganizationResourceListResult() {
    }

    public List<OrganizationResourceInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model OrganizationResourceListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static OrganizationResourceListResult fromJson(JsonReader jsonReader) throws IOException {
        return (OrganizationResourceListResult)jsonReader.readObject(reader -> {
            OrganizationResourceListResult deserializedOrganizationResourceListResult = new OrganizationResourceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedOrganizationResourceListResult.value = value = reader.readArray(reader1 -> OrganizationResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedOrganizationResourceListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOrganizationResourceListResult;
        });
    }
}

