/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.MhsmGeoReplicatedRegionInner;
import com.azure.resourcemanager.keyvault.models.CreateMode;
import com.azure.resourcemanager.keyvault.models.ManagedHsmSecurityDomainProperties;
import com.azure.resourcemanager.keyvault.models.MhsmNetworkRuleSet;
import com.azure.resourcemanager.keyvault.models.MhsmPrivateEndpointConnectionItem;
import com.azure.resourcemanager.keyvault.models.ProvisioningState;
import com.azure.resourcemanager.keyvault.models.PublicNetworkAccess;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class ManagedHsmProperties
implements JsonSerializable<ManagedHsmProperties> {
    private UUID tenantId;
    private List<String> initialAdminObjectIds;
    private String hsmUri;
    private Boolean enableSoftDelete;
    private Integer softDeleteRetentionInDays;
    private Boolean enablePurgeProtection;
    private CreateMode createMode;
    private String statusMessage;
    private ProvisioningState provisioningState;
    private MhsmNetworkRuleSet networkAcls;
    private List<MhsmGeoReplicatedRegionInner> regions;
    private List<MhsmPrivateEndpointConnectionItem> privateEndpointConnections;
    private PublicNetworkAccess publicNetworkAccess;
    private OffsetDateTime scheduledPurgeDate;
    private ManagedHsmSecurityDomainProperties securityDomainProperties;

    public UUID tenantId() {
        return this.tenantId;
    }

    public ManagedHsmProperties withTenantId(UUID tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public List<String> initialAdminObjectIds() {
        return this.initialAdminObjectIds;
    }

    public ManagedHsmProperties withInitialAdminObjectIds(List<String> initialAdminObjectIds) {
        this.initialAdminObjectIds = initialAdminObjectIds;
        return this;
    }

    public String hsmUri() {
        return this.hsmUri;
    }

    public Boolean enableSoftDelete() {
        return this.enableSoftDelete;
    }

    public ManagedHsmProperties withEnableSoftDelete(Boolean enableSoftDelete) {
        this.enableSoftDelete = enableSoftDelete;
        return this;
    }

    public Integer softDeleteRetentionInDays() {
        return this.softDeleteRetentionInDays;
    }

    public ManagedHsmProperties withSoftDeleteRetentionInDays(Integer softDeleteRetentionInDays) {
        this.softDeleteRetentionInDays = softDeleteRetentionInDays;
        return this;
    }

    public Boolean enablePurgeProtection() {
        return this.enablePurgeProtection;
    }

    public ManagedHsmProperties withEnablePurgeProtection(Boolean enablePurgeProtection) {
        this.enablePurgeProtection = enablePurgeProtection;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public ManagedHsmProperties withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public MhsmNetworkRuleSet networkAcls() {
        return this.networkAcls;
    }

    public ManagedHsmProperties withNetworkAcls(MhsmNetworkRuleSet networkAcls) {
        this.networkAcls = networkAcls;
        return this;
    }

    public List<MhsmGeoReplicatedRegionInner> regions() {
        return this.regions;
    }

    public ManagedHsmProperties withRegions(List<MhsmGeoReplicatedRegionInner> regions) {
        this.regions = regions;
        return this;
    }

    public List<MhsmPrivateEndpointConnectionItem> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ManagedHsmProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public OffsetDateTime scheduledPurgeDate() {
        return this.scheduledPurgeDate;
    }

    public ManagedHsmSecurityDomainProperties securityDomainProperties() {
        return this.securityDomainProperties;
    }

    public void validate() {
        if (this.networkAcls() != null) {
            this.networkAcls().validate();
        }
        if (this.regions() != null) {
            this.regions().forEach(e -> e.validate());
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.securityDomainProperties() != null) {
            this.securityDomainProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tenantId", Objects.toString(this.tenantId, null));
        jsonWriter.writeArrayField("initialAdminObjectIds", this.initialAdminObjectIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("enableSoftDelete", this.enableSoftDelete);
        jsonWriter.writeNumberField("softDeleteRetentionInDays", (Number)this.softDeleteRetentionInDays);
        jsonWriter.writeBooleanField("enablePurgeProtection", this.enablePurgeProtection);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        jsonWriter.writeJsonField("networkAcls", (JsonSerializable)this.networkAcls);
        jsonWriter.writeArrayField("regions", this.regions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        return jsonWriter.writeEndObject();
    }

    public static ManagedHsmProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedHsmProperties)jsonReader.readObject(reader -> {
            ManagedHsmProperties deserializedManagedHsmProperties = new ManagedHsmProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tenantId".equals(fieldName)) {
                    deserializedManagedHsmProperties.tenantId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("initialAdminObjectIds".equals(fieldName)) {
                    List initialAdminObjectIds;
                    deserializedManagedHsmProperties.initialAdminObjectIds = initialAdminObjectIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("hsmUri".equals(fieldName)) {
                    deserializedManagedHsmProperties.hsmUri = reader.getString();
                    continue;
                }
                if ("enableSoftDelete".equals(fieldName)) {
                    deserializedManagedHsmProperties.enableSoftDelete = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("softDeleteRetentionInDays".equals(fieldName)) {
                    deserializedManagedHsmProperties.softDeleteRetentionInDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("enablePurgeProtection".equals(fieldName)) {
                    deserializedManagedHsmProperties.enablePurgeProtection = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedManagedHsmProperties.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                if ("statusMessage".equals(fieldName)) {
                    deserializedManagedHsmProperties.statusMessage = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedManagedHsmProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("networkAcls".equals(fieldName)) {
                    deserializedManagedHsmProperties.networkAcls = MhsmNetworkRuleSet.fromJson(reader);
                    continue;
                }
                if ("regions".equals(fieldName)) {
                    List regions;
                    deserializedManagedHsmProperties.regions = regions = reader.readArray(reader1 -> MhsmGeoReplicatedRegionInner.fromJson(reader1));
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedManagedHsmProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> MhsmPrivateEndpointConnectionItem.fromJson(reader1));
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedManagedHsmProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedManagedHsmProperties.scheduledPurgeDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("securityDomainProperties".equals(fieldName)) {
                    deserializedManagedHsmProperties.securityDomainProperties = ManagedHsmSecurityDomainProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedHsmProperties;
        });
    }
}

