/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.KeyRotationPolicyAttributes;
import com.azure.resourcemanager.keyvault.models.LifetimeAction;
import java.io.IOException;
import java.util.List;

public final class RotationPolicy
implements JsonSerializable<RotationPolicy> {
    private KeyRotationPolicyAttributes attributes;
    private List<LifetimeAction> lifetimeActions;

    public KeyRotationPolicyAttributes attributes() {
        return this.attributes;
    }

    public RotationPolicy withAttributes(KeyRotationPolicyAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public List<LifetimeAction> lifetimeActions() {
        return this.lifetimeActions;
    }

    public RotationPolicy withLifetimeActions(List<LifetimeAction> lifetimeActions) {
        this.lifetimeActions = lifetimeActions;
        return this;
    }

    public void validate() {
        if (this.attributes() != null) {
            this.attributes().validate();
        }
        if (this.lifetimeActions() != null) {
            this.lifetimeActions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        jsonWriter.writeArrayField("lifetimeActions", this.lifetimeActions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RotationPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (RotationPolicy)jsonReader.readObject(reader -> {
            RotationPolicy deserializedRotationPolicy = new RotationPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("attributes".equals(fieldName)) {
                    deserializedRotationPolicy.attributes = KeyRotationPolicyAttributes.fromJson(reader);
                    continue;
                }
                if ("lifetimeActions".equals(fieldName)) {
                    List lifetimeActions;
                    deserializedRotationPolicy.lifetimeActions = lifetimeActions = reader.readArray(reader1 -> LifetimeAction.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRotationPolicy;
        });
    }
}

