/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.keyvault.fluent.KeyVaultManagementClient;
import com.azure.resourcemanager.keyvault.implementation.KeyVaultManagementClientBuilder;
import com.azure.resourcemanager.keyvault.implementation.VaultsImpl;
import com.azure.resourcemanager.keyvault.models.Vaults;
import com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;

public final class KeyVaultManager
extends Manager<KeyVaultManagementClient> {
    private final AuthorizationManager authorizationManager;
    private Vaults vaults;
    private final String tenantId;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static KeyVaultManager authenticate(TokenCredential credential, AzureProfile profile) {
        return KeyVaultManager.authenticate(HttpPipelineProvider.buildHttpPipeline((TokenCredential)credential, (AzureProfile)profile), profile);
    }

    private static KeyVaultManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        return new KeyVaultManager(httpPipeline, profile);
    }

    private KeyVaultManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, (Object)new KeyVaultManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
        this.authorizationManager = ((AuthorizationManager.Configurable)AzureConfigurableImpl.configureHttpPipeline((HttpPipeline)httpPipeline, (AzureConfigurable)AuthorizationManager.configure())).authenticate(null, profile);
        this.tenantId = profile.getTenantId();
    }

    public Vaults vaults() {
        if (this.vaults == null) {
            this.vaults = new VaultsImpl(this, this.authorizationManager, this.tenantId);
        }
        return this.vaults;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public KeyVaultManager authenticate(TokenCredential credential, AzureProfile profile) {
            return KeyVaultManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public KeyVaultManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

