/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmClusterSkuFamily;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmClusterSkuName;
import java.io.IOException;

public final class CloudHsmClusterSku
implements JsonSerializable<CloudHsmClusterSku> {
    private CloudHsmClusterSkuFamily family;
    private CloudHsmClusterSkuName name;
    private Integer capacity;
    private static final ClientLogger LOGGER = new ClientLogger(CloudHsmClusterSku.class);

    public CloudHsmClusterSkuFamily family() {
        return this.family;
    }

    public CloudHsmClusterSku withFamily(CloudHsmClusterSkuFamily family) {
        this.family = family;
        return this;
    }

    public CloudHsmClusterSkuName name() {
        return this.name;
    }

    public CloudHsmClusterSku withName(CloudHsmClusterSkuName name) {
        this.name = name;
        return this;
    }

    public Integer capacity() {
        return this.capacity;
    }

    public CloudHsmClusterSku withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    public void validate() {
        if (this.family() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property family in model CloudHsmClusterSku"));
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model CloudHsmClusterSku"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("family", this.family == null ? null : this.family.toString());
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeNumberField("capacity", (Number)this.capacity);
        return jsonWriter.writeEndObject();
    }

    public static CloudHsmClusterSku fromJson(JsonReader jsonReader) throws IOException {
        return (CloudHsmClusterSku)jsonReader.readObject(reader -> {
            CloudHsmClusterSku deserializedCloudHsmClusterSku = new CloudHsmClusterSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("family".equals(fieldName)) {
                    deserializedCloudHsmClusterSku.family = CloudHsmClusterSkuFamily.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCloudHsmClusterSku.name = CloudHsmClusterSkuName.fromString(reader.getString());
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedCloudHsmClusterSku.capacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudHsmClusterSku;
        });
    }
}

