/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.hardwaresecuritymodules.models.ActivationState;
import com.azure.resourcemanager.hardwaresecuritymodules.models.AutoGeneratedDomainNameLabelScope;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmProperties;
import com.azure.resourcemanager.hardwaresecuritymodules.models.ProvisioningState;
import com.azure.resourcemanager.hardwaresecuritymodules.models.PublicNetworkAccess;
import java.io.IOException;
import java.util.List;

public final class CloudHsmClusterProperties
implements JsonSerializable<CloudHsmClusterProperties> {
    private ActivationState activationState;
    private AutoGeneratedDomainNameLabelScope autoGeneratedDomainNameLabelScope;
    private List<CloudHsmProperties> hsms;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private ProvisioningState provisioningState;
    private PublicNetworkAccess publicNetworkAccess;
    private String statusMessage;

    public ActivationState activationState() {
        return this.activationState;
    }

    public AutoGeneratedDomainNameLabelScope autoGeneratedDomainNameLabelScope() {
        return this.autoGeneratedDomainNameLabelScope;
    }

    public CloudHsmClusterProperties withAutoGeneratedDomainNameLabelScope(AutoGeneratedDomainNameLabelScope autoGeneratedDomainNameLabelScope) {
        this.autoGeneratedDomainNameLabelScope = autoGeneratedDomainNameLabelScope;
        return this;
    }

    public List<CloudHsmProperties> hsms() {
        return this.hsms;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public CloudHsmClusterProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public void validate() {
        if (this.hsms() != null) {
            this.hsms().forEach(e -> e.validate());
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("autoGeneratedDomainNameLabelScope", this.autoGeneratedDomainNameLabelScope == null ? null : this.autoGeneratedDomainNameLabelScope.toString());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        return jsonWriter.writeEndObject();
    }

    public static CloudHsmClusterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CloudHsmClusterProperties)jsonReader.readObject(reader -> {
            CloudHsmClusterProperties deserializedCloudHsmClusterProperties = new CloudHsmClusterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("activationState".equals(fieldName)) {
                    deserializedCloudHsmClusterProperties.activationState = ActivationState.fromString(reader.getString());
                    continue;
                }
                if ("autoGeneratedDomainNameLabelScope".equals(fieldName)) {
                    deserializedCloudHsmClusterProperties.autoGeneratedDomainNameLabelScope = AutoGeneratedDomainNameLabelScope.fromString(reader.getString());
                    continue;
                }
                if ("hsms".equals(fieldName)) {
                    List hsms;
                    deserializedCloudHsmClusterProperties.hsms = hsms = reader.readArray(reader1 -> CloudHsmProperties.fromJson(reader1));
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedCloudHsmClusterProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCloudHsmClusterProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedCloudHsmClusterProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("statusMessage".equals(fieldName)) {
                    deserializedCloudHsmClusterProperties.statusMessage = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudHsmClusterProperties;
        });
    }
}

