/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.CloudHsmClusterInner;
import com.azure.resourcemanager.hardwaresecuritymodules.models.BackupRequestProperties;
import com.azure.resourcemanager.hardwaresecuritymodules.models.BackupResult;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmClusterProperties;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmClusterSku;
import com.azure.resourcemanager.hardwaresecuritymodules.models.ManagedServiceIdentity;
import com.azure.resourcemanager.hardwaresecuritymodules.models.RestoreRequestProperties;
import com.azure.resourcemanager.hardwaresecuritymodules.models.RestoreResult;
import java.util.Map;

public interface CloudHsmCluster {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public CloudHsmClusterProperties properties();

    public ManagedServiceIdentity identity();

    public CloudHsmClusterSku sku();

    public SystemData systemData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public CloudHsmClusterInner innerModel();

    public Update update();

    public CloudHsmCluster refresh();

    public CloudHsmCluster refresh(Context var1);

    public BackupResult validateBackupProperties();

    public BackupResult validateBackupProperties(BackupRequestProperties var1, Context var2);

    public BackupResult backup();

    public BackupResult backup(BackupRequestProperties var1, Context var2);

    public RestoreResult validateRestoreProperties();

    public RestoreResult validateRestoreProperties(RestoreRequestProperties var1, Context var2);

    public RestoreResult restore(RestoreRequestProperties var1);

    public RestoreResult restore(RestoreRequestProperties var1, Context var2);

    public static interface UpdateStages {

        public static interface WithIdentity {
            public Update withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity {
        public CloudHsmCluster apply();

        public CloudHsmCluster apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithSku {
            public WithCreate withSku(CloudHsmClusterSku var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(CloudHsmClusterProperties var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithProperties,
        WithIdentity,
        WithSku {
            public CloudHsmCluster create();

            public CloudHsmCluster create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

