/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.hardwaresecuritymodules.models.BackupRestoreOperationStatus;
import java.io.IOException;
import java.time.OffsetDateTime;

public class BackupRestoreBaseResultProperties
implements JsonSerializable<BackupRestoreBaseResultProperties> {
    private BackupRestoreOperationStatus status;
    private String statusDetails;
    private ManagementError error;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private String jobId;

    protected BackupRestoreBaseResultProperties() {
    }

    public BackupRestoreOperationStatus status() {
        return this.status;
    }

    BackupRestoreBaseResultProperties withStatus(BackupRestoreOperationStatus status) {
        this.status = status;
        return this;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    BackupRestoreBaseResultProperties withStatusDetails(String statusDetails) {
        this.statusDetails = statusDetails;
        return this;
    }

    public ManagementError error() {
        return this.error;
    }

    BackupRestoreBaseResultProperties withError(ManagementError error) {
        this.error = error;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    BackupRestoreBaseResultProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    BackupRestoreBaseResultProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public String jobId() {
        return this.jobId;
    }

    BackupRestoreBaseResultProperties withJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("statusDetails", this.statusDetails);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeStringField("jobId", this.jobId);
        return jsonWriter.writeEndObject();
    }

    public static BackupRestoreBaseResultProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BackupRestoreBaseResultProperties)jsonReader.readObject(reader -> {
            BackupRestoreBaseResultProperties deserializedBackupRestoreBaseResultProperties = new BackupRestoreBaseResultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedBackupRestoreBaseResultProperties.status = BackupRestoreOperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("statusDetails".equals(fieldName)) {
                    deserializedBackupRestoreBaseResultProperties.statusDetails = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedBackupRestoreBaseResultProperties.error = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedBackupRestoreBaseResultProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedBackupRestoreBaseResultProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("jobId".equals(fieldName)) {
                    deserializedBackupRestoreBaseResultProperties.jobId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupRestoreBaseResultProperties;
        });
    }
}

