/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.hardwaresecuritymodules.models.BackupRestoreRequestBaseProperties;
import java.io.IOException;

public final class BackupRequestProperties
extends BackupRestoreRequestBaseProperties {
    private static final ClientLogger LOGGER = new ClientLogger(BackupRequestProperties.class);

    @Override
    public BackupRequestProperties withAzureStorageBlobContainerUri(String azureStorageBlobContainerUri) {
        super.withAzureStorageBlobContainerUri(azureStorageBlobContainerUri);
        return this;
    }

    @Override
    public BackupRequestProperties withToken(String token) {
        super.withToken(token);
        return this;
    }

    @Override
    public void validate() {
        if (this.azureStorageBlobContainerUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property azureStorageBlobContainerUri in model BackupRequestProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("azureStorageBlobContainerUri", this.azureStorageBlobContainerUri());
        jsonWriter.writeStringField("token", this.token());
        return jsonWriter.writeEndObject();
    }

    public static BackupRequestProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BackupRequestProperties)jsonReader.readObject(reader -> {
            BackupRequestProperties deserializedBackupRequestProperties = new BackupRequestProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("azureStorageBlobContainerUri".equals(fieldName)) {
                    deserializedBackupRequestProperties.withAzureStorageBlobContainerUri(reader.getString());
                    continue;
                }
                if ("token".equals(fieldName)) {
                    deserializedBackupRequestProperties.withToken(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupRequestProperties;
        });
    }
}

