/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.CloudHsmClustersClient;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.BackupResultInner;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.CloudHsmClusterInner;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.RestoreResultInner;
import com.azure.resourcemanager.hardwaresecuritymodules.implementation.HardwareSecurityModulesManagementClientImpl;
import com.azure.resourcemanager.hardwaresecuritymodules.implementation.models.CloudHsmClusterListResult;
import com.azure.resourcemanager.hardwaresecuritymodules.models.BackupRequestProperties;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmClusterPatchParameters;
import com.azure.resourcemanager.hardwaresecuritymodules.models.RestoreRequestProperties;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class CloudHsmClustersClientImpl
implements CloudHsmClustersClient {
    private final CloudHsmClustersService service;
    private final HardwareSecurityModulesManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(CloudHsmClustersClientImpl.class);

    CloudHsmClustersClientImpl(HardwareSecurityModulesManagementClientImpl client) {
        this.service = (CloudHsmClustersService)RestProxy.create(CloudHsmClustersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CloudHsmClusterInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String cloudHsmClusterName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CloudHsmClusterInner> getByResourceGroupAsync(String resourceGroupName, String cloudHsmClusterName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, cloudHsmClusterName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((CloudHsmClusterInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CloudHsmClusterInner> getByResourceGroupWithResponse(String resourceGroupName, String cloudHsmClusterName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloudHsmClusterInner getByResourceGroup(String resourceGroupName, String cloudHsmClusterName) {
        return (CloudHsmClusterInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, cloudHsmClusterName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String cloudHsmClusterName, CloudHsmClusterInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", "application/json", body, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String cloudHsmClusterName, CloudHsmClusterInner body) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", "application/json", body, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String cloudHsmClusterName, CloudHsmClusterInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", "application/json", body, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CloudHsmClusterInner>, CloudHsmClusterInner> beginCreateOrUpdateAsync(String resourceGroupName, String cloudHsmClusterName, CloudHsmClusterInner body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, cloudHsmClusterName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)CloudHsmClusterInner.class), (Type)((Object)CloudHsmClusterInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CloudHsmClusterInner>, CloudHsmClusterInner> beginCreateOrUpdate(String resourceGroupName, String cloudHsmClusterName, CloudHsmClusterInner body) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, cloudHsmClusterName, body);
        return this.client.getLroResult(response, (Type)((Object)CloudHsmClusterInner.class), (Type)((Object)CloudHsmClusterInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CloudHsmClusterInner>, CloudHsmClusterInner> beginCreateOrUpdate(String resourceGroupName, String cloudHsmClusterName, CloudHsmClusterInner body, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, cloudHsmClusterName, body, context);
        return this.client.getLroResult(response, (Type)((Object)CloudHsmClusterInner.class), (Type)((Object)CloudHsmClusterInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CloudHsmClusterInner> createOrUpdateAsync(String resourceGroupName, String cloudHsmClusterName, CloudHsmClusterInner body) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, cloudHsmClusterName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloudHsmClusterInner createOrUpdate(String resourceGroupName, String cloudHsmClusterName, CloudHsmClusterInner body) {
        return (CloudHsmClusterInner)((Object)this.beginCreateOrUpdate(resourceGroupName, cloudHsmClusterName, body).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloudHsmClusterInner createOrUpdate(String resourceGroupName, String cloudHsmClusterName, CloudHsmClusterInner body, Context context) {
        return (CloudHsmClusterInner)((Object)this.beginCreateOrUpdate(resourceGroupName, cloudHsmClusterName, body, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String cloudHsmClusterName, CloudHsmClusterPatchParameters body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", "application/json", body, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String cloudHsmClusterName, CloudHsmClusterPatchParameters body) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", "application/json", body, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String cloudHsmClusterName, CloudHsmClusterPatchParameters body, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", "application/json", body, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CloudHsmClusterInner>, CloudHsmClusterInner> beginUpdateAsync(String resourceGroupName, String cloudHsmClusterName, CloudHsmClusterPatchParameters body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, cloudHsmClusterName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)CloudHsmClusterInner.class), (Type)((Object)CloudHsmClusterInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CloudHsmClusterInner>, CloudHsmClusterInner> beginUpdate(String resourceGroupName, String cloudHsmClusterName, CloudHsmClusterPatchParameters body) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, cloudHsmClusterName, body);
        return this.client.getLroResult(response, (Type)((Object)CloudHsmClusterInner.class), (Type)((Object)CloudHsmClusterInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CloudHsmClusterInner>, CloudHsmClusterInner> beginUpdate(String resourceGroupName, String cloudHsmClusterName, CloudHsmClusterPatchParameters body, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, cloudHsmClusterName, body, context);
        return this.client.getLroResult(response, (Type)((Object)CloudHsmClusterInner.class), (Type)((Object)CloudHsmClusterInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CloudHsmClusterInner> updateAsync(String resourceGroupName, String cloudHsmClusterName, CloudHsmClusterPatchParameters body) {
        return this.beginUpdateAsync(resourceGroupName, cloudHsmClusterName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloudHsmClusterInner update(String resourceGroupName, String cloudHsmClusterName, CloudHsmClusterPatchParameters body) {
        return (CloudHsmClusterInner)((Object)this.beginUpdate(resourceGroupName, cloudHsmClusterName, body).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloudHsmClusterInner update(String resourceGroupName, String cloudHsmClusterName, CloudHsmClusterPatchParameters body, Context context) {
        return (CloudHsmClusterInner)((Object)this.beginUpdate(resourceGroupName, cloudHsmClusterName, body, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String cloudHsmClusterName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String cloudHsmClusterName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String cloudHsmClusterName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String cloudHsmClusterName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, cloudHsmClusterName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String cloudHsmClusterName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, cloudHsmClusterName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String cloudHsmClusterName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, cloudHsmClusterName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String cloudHsmClusterName) {
        return this.beginDeleteAsync(resourceGroupName, cloudHsmClusterName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String cloudHsmClusterName) {
        this.beginDelete(resourceGroupName, cloudHsmClusterName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String cloudHsmClusterName, Context context) {
        this.beginDelete(resourceGroupName, cloudHsmClusterName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CloudHsmClusterInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, String skiptoken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, skiptoken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudHsmClusterListResult)res.getValue()).value(), ((CloudHsmClusterListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CloudHsmClusterInner> listByResourceGroupAsync(String resourceGroupName, String skiptoken) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, skiptoken), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CloudHsmClusterInner> listByResourceGroupAsync(String resourceGroupName) {
        String skiptoken = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, skiptoken), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CloudHsmClusterInner> listByResourceGroupSinglePage(String resourceGroupName, String skiptoken) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CloudHsmClusterListResult> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, skiptoken, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudHsmClusterListResult)res.getValue()).value(), ((CloudHsmClusterListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CloudHsmClusterInner> listByResourceGroupSinglePage(String resourceGroupName, String skiptoken, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CloudHsmClusterListResult> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, skiptoken, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudHsmClusterListResult)res.getValue()).value(), ((CloudHsmClusterListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CloudHsmClusterInner> listByResourceGroup(String resourceGroupName) {
        String skiptoken = null;
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName, skiptoken), nextLink -> this.listByResourceGroupNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CloudHsmClusterInner> listByResourceGroup(String resourceGroupName, String skiptoken, Context context) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName, skiptoken, context), nextLink -> this.listByResourceGroupNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CloudHsmClusterInner>> listSinglePageAsync(String skiptoken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), skiptoken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudHsmClusterListResult)res.getValue()).value(), ((CloudHsmClusterListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CloudHsmClusterInner> listAsync(String skiptoken) {
        return new PagedFlux(() -> this.listSinglePageAsync(skiptoken), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CloudHsmClusterInner> listAsync() {
        String skiptoken = null;
        return new PagedFlux(() -> this.listSinglePageAsync(skiptoken), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CloudHsmClusterInner> listSinglePage(String skiptoken) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CloudHsmClusterListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), skiptoken, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudHsmClusterListResult)res.getValue()).value(), ((CloudHsmClusterListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CloudHsmClusterInner> listSinglePage(String skiptoken, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CloudHsmClusterListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), skiptoken, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudHsmClusterListResult)res.getValue()).value(), ((CloudHsmClusterListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CloudHsmClusterInner> list() {
        String skiptoken = null;
        return new PagedIterable(() -> this.listSinglePage(skiptoken), nextLink -> this.listBySubscriptionNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CloudHsmClusterInner> list(String skiptoken, Context context) {
        return new PagedIterable(() -> this.listSinglePage(skiptoken, context), nextLink -> this.listBySubscriptionNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateBackupPropertiesWithResponseAsync(String resourceGroupName, String cloudHsmClusterName, BackupRequestProperties backupRequestProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (backupRequestProperties != null) {
            backupRequestProperties.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateBackupProperties(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", backupRequestProperties, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> validateBackupPropertiesWithResponse(String resourceGroupName, String cloudHsmClusterName, BackupRequestProperties backupRequestProperties) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (backupRequestProperties != null) {
            backupRequestProperties.validate();
        }
        String accept = "application/json";
        return this.service.validateBackupPropertiesSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", backupRequestProperties, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> validateBackupPropertiesWithResponse(String resourceGroupName, String cloudHsmClusterName, BackupRequestProperties backupRequestProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (backupRequestProperties != null) {
            backupRequestProperties.validate();
        }
        String accept = "application/json";
        return this.service.validateBackupPropertiesSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", backupRequestProperties, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BackupResultInner>, BackupResultInner> beginValidateBackupPropertiesAsync(String resourceGroupName, String cloudHsmClusterName, BackupRequestProperties backupRequestProperties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateBackupPropertiesWithResponseAsync(resourceGroupName, cloudHsmClusterName, backupRequestProperties);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BackupResultInner.class), (Type)((Object)BackupResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BackupResultInner>, BackupResultInner> beginValidateBackupPropertiesAsync(String resourceGroupName, String cloudHsmClusterName) {
        BackupRequestProperties backupRequestProperties = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateBackupPropertiesWithResponseAsync(resourceGroupName, cloudHsmClusterName, backupRequestProperties);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BackupResultInner.class), (Type)((Object)BackupResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BackupResultInner>, BackupResultInner> beginValidateBackupProperties(String resourceGroupName, String cloudHsmClusterName, BackupRequestProperties backupRequestProperties) {
        Response<BinaryData> response = this.validateBackupPropertiesWithResponse(resourceGroupName, cloudHsmClusterName, backupRequestProperties);
        return this.client.getLroResult(response, (Type)((Object)BackupResultInner.class), (Type)((Object)BackupResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BackupResultInner>, BackupResultInner> beginValidateBackupProperties(String resourceGroupName, String cloudHsmClusterName) {
        BackupRequestProperties backupRequestProperties = null;
        Response<BinaryData> response = this.validateBackupPropertiesWithResponse(resourceGroupName, cloudHsmClusterName, backupRequestProperties);
        return this.client.getLroResult(response, (Type)((Object)BackupResultInner.class), (Type)((Object)BackupResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BackupResultInner>, BackupResultInner> beginValidateBackupProperties(String resourceGroupName, String cloudHsmClusterName, BackupRequestProperties backupRequestProperties, Context context) {
        Response<BinaryData> response = this.validateBackupPropertiesWithResponse(resourceGroupName, cloudHsmClusterName, backupRequestProperties, context);
        return this.client.getLroResult(response, (Type)((Object)BackupResultInner.class), (Type)((Object)BackupResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BackupResultInner> validateBackupPropertiesAsync(String resourceGroupName, String cloudHsmClusterName, BackupRequestProperties backupRequestProperties) {
        return this.beginValidateBackupPropertiesAsync(resourceGroupName, cloudHsmClusterName, backupRequestProperties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BackupResultInner> validateBackupPropertiesAsync(String resourceGroupName, String cloudHsmClusterName) {
        BackupRequestProperties backupRequestProperties = null;
        return this.beginValidateBackupPropertiesAsync(resourceGroupName, cloudHsmClusterName, backupRequestProperties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupResultInner validateBackupProperties(String resourceGroupName, String cloudHsmClusterName) {
        BackupRequestProperties backupRequestProperties = null;
        return (BackupResultInner)this.beginValidateBackupProperties(resourceGroupName, cloudHsmClusterName, backupRequestProperties).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupResultInner validateBackupProperties(String resourceGroupName, String cloudHsmClusterName, BackupRequestProperties backupRequestProperties, Context context) {
        return (BackupResultInner)this.beginValidateBackupProperties(resourceGroupName, cloudHsmClusterName, backupRequestProperties, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> backupWithResponseAsync(String resourceGroupName, String cloudHsmClusterName, BackupRequestProperties backupRequestProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (backupRequestProperties != null) {
            backupRequestProperties.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.backup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", backupRequestProperties, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> backupWithResponse(String resourceGroupName, String cloudHsmClusterName, BackupRequestProperties backupRequestProperties) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (backupRequestProperties != null) {
            backupRequestProperties.validate();
        }
        String accept = "application/json";
        return this.service.backupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", backupRequestProperties, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> backupWithResponse(String resourceGroupName, String cloudHsmClusterName, BackupRequestProperties backupRequestProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (backupRequestProperties != null) {
            backupRequestProperties.validate();
        }
        String accept = "application/json";
        return this.service.backupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", backupRequestProperties, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BackupResultInner>, BackupResultInner> beginBackupAsync(String resourceGroupName, String cloudHsmClusterName, BackupRequestProperties backupRequestProperties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.backupWithResponseAsync(resourceGroupName, cloudHsmClusterName, backupRequestProperties);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BackupResultInner.class), (Type)((Object)BackupResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BackupResultInner>, BackupResultInner> beginBackupAsync(String resourceGroupName, String cloudHsmClusterName) {
        BackupRequestProperties backupRequestProperties = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.backupWithResponseAsync(resourceGroupName, cloudHsmClusterName, backupRequestProperties);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BackupResultInner.class), (Type)((Object)BackupResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BackupResultInner>, BackupResultInner> beginBackup(String resourceGroupName, String cloudHsmClusterName, BackupRequestProperties backupRequestProperties) {
        Response<BinaryData> response = this.backupWithResponse(resourceGroupName, cloudHsmClusterName, backupRequestProperties);
        return this.client.getLroResult(response, (Type)((Object)BackupResultInner.class), (Type)((Object)BackupResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BackupResultInner>, BackupResultInner> beginBackup(String resourceGroupName, String cloudHsmClusterName) {
        BackupRequestProperties backupRequestProperties = null;
        Response<BinaryData> response = this.backupWithResponse(resourceGroupName, cloudHsmClusterName, backupRequestProperties);
        return this.client.getLroResult(response, (Type)((Object)BackupResultInner.class), (Type)((Object)BackupResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BackupResultInner>, BackupResultInner> beginBackup(String resourceGroupName, String cloudHsmClusterName, BackupRequestProperties backupRequestProperties, Context context) {
        Response<BinaryData> response = this.backupWithResponse(resourceGroupName, cloudHsmClusterName, backupRequestProperties, context);
        return this.client.getLroResult(response, (Type)((Object)BackupResultInner.class), (Type)((Object)BackupResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BackupResultInner> backupAsync(String resourceGroupName, String cloudHsmClusterName, BackupRequestProperties backupRequestProperties) {
        return this.beginBackupAsync(resourceGroupName, cloudHsmClusterName, backupRequestProperties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BackupResultInner> backupAsync(String resourceGroupName, String cloudHsmClusterName) {
        BackupRequestProperties backupRequestProperties = null;
        return this.beginBackupAsync(resourceGroupName, cloudHsmClusterName, backupRequestProperties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupResultInner backup(String resourceGroupName, String cloudHsmClusterName) {
        BackupRequestProperties backupRequestProperties = null;
        return (BackupResultInner)this.beginBackup(resourceGroupName, cloudHsmClusterName, backupRequestProperties).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupResultInner backup(String resourceGroupName, String cloudHsmClusterName, BackupRequestProperties backupRequestProperties, Context context) {
        return (BackupResultInner)this.beginBackup(resourceGroupName, cloudHsmClusterName, backupRequestProperties, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateRestorePropertiesWithResponseAsync(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (restoreRequestProperties != null) {
            restoreRequestProperties.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateRestoreProperties(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", restoreRequestProperties, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> validateRestorePropertiesWithResponse(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (restoreRequestProperties != null) {
            restoreRequestProperties.validate();
        }
        String accept = "application/json";
        return this.service.validateRestorePropertiesSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", restoreRequestProperties, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> validateRestorePropertiesWithResponse(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (restoreRequestProperties != null) {
            restoreRequestProperties.validate();
        }
        String accept = "application/json";
        return this.service.validateRestorePropertiesSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", restoreRequestProperties, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<RestoreResultInner>, RestoreResultInner> beginValidateRestorePropertiesAsync(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateRestorePropertiesWithResponseAsync(resourceGroupName, cloudHsmClusterName, restoreRequestProperties);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)RestoreResultInner.class), (Type)((Object)RestoreResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<RestoreResultInner>, RestoreResultInner> beginValidateRestorePropertiesAsync(String resourceGroupName, String cloudHsmClusterName) {
        RestoreRequestProperties restoreRequestProperties = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateRestorePropertiesWithResponseAsync(resourceGroupName, cloudHsmClusterName, restoreRequestProperties);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)RestoreResultInner.class), (Type)((Object)RestoreResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RestoreResultInner>, RestoreResultInner> beginValidateRestoreProperties(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties) {
        Response<BinaryData> response = this.validateRestorePropertiesWithResponse(resourceGroupName, cloudHsmClusterName, restoreRequestProperties);
        return this.client.getLroResult(response, (Type)((Object)RestoreResultInner.class), (Type)((Object)RestoreResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RestoreResultInner>, RestoreResultInner> beginValidateRestoreProperties(String resourceGroupName, String cloudHsmClusterName) {
        RestoreRequestProperties restoreRequestProperties = null;
        Response<BinaryData> response = this.validateRestorePropertiesWithResponse(resourceGroupName, cloudHsmClusterName, restoreRequestProperties);
        return this.client.getLroResult(response, (Type)((Object)RestoreResultInner.class), (Type)((Object)RestoreResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RestoreResultInner>, RestoreResultInner> beginValidateRestoreProperties(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties, Context context) {
        Response<BinaryData> response = this.validateRestorePropertiesWithResponse(resourceGroupName, cloudHsmClusterName, restoreRequestProperties, context);
        return this.client.getLroResult(response, (Type)((Object)RestoreResultInner.class), (Type)((Object)RestoreResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RestoreResultInner> validateRestorePropertiesAsync(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties) {
        return this.beginValidateRestorePropertiesAsync(resourceGroupName, cloudHsmClusterName, restoreRequestProperties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RestoreResultInner> validateRestorePropertiesAsync(String resourceGroupName, String cloudHsmClusterName) {
        RestoreRequestProperties restoreRequestProperties = null;
        return this.beginValidateRestorePropertiesAsync(resourceGroupName, cloudHsmClusterName, restoreRequestProperties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RestoreResultInner validateRestoreProperties(String resourceGroupName, String cloudHsmClusterName) {
        RestoreRequestProperties restoreRequestProperties = null;
        return (RestoreResultInner)this.beginValidateRestoreProperties(resourceGroupName, cloudHsmClusterName, restoreRequestProperties).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RestoreResultInner validateRestoreProperties(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties, Context context) {
        return (RestoreResultInner)this.beginValidateRestoreProperties(resourceGroupName, cloudHsmClusterName, restoreRequestProperties, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restoreWithResponseAsync(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (restoreRequestProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restoreRequestProperties is required and cannot be null."));
        }
        restoreRequestProperties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restore(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", "application/json", restoreRequestProperties, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> restoreWithResponse(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (restoreRequestProperties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter restoreRequestProperties is required and cannot be null."));
        }
        restoreRequestProperties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.restoreSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", "application/json", restoreRequestProperties, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> restoreWithResponse(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (restoreRequestProperties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter restoreRequestProperties is required and cannot be null."));
        }
        restoreRequestProperties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.restoreSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, "application/json", "application/json", restoreRequestProperties, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<RestoreResultInner>, RestoreResultInner> beginRestoreAsync(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restoreWithResponseAsync(resourceGroupName, cloudHsmClusterName, restoreRequestProperties);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)RestoreResultInner.class), (Type)((Object)RestoreResultInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RestoreResultInner>, RestoreResultInner> beginRestore(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties) {
        Response<BinaryData> response = this.restoreWithResponse(resourceGroupName, cloudHsmClusterName, restoreRequestProperties);
        return this.client.getLroResult(response, (Type)((Object)RestoreResultInner.class), (Type)((Object)RestoreResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RestoreResultInner>, RestoreResultInner> beginRestore(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties, Context context) {
        Response<BinaryData> response = this.restoreWithResponse(resourceGroupName, cloudHsmClusterName, restoreRequestProperties, context);
        return this.client.getLroResult(response, (Type)((Object)RestoreResultInner.class), (Type)((Object)RestoreResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RestoreResultInner> restoreAsync(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties) {
        return this.beginRestoreAsync(resourceGroupName, cloudHsmClusterName, restoreRequestProperties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RestoreResultInner restore(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties) {
        return (RestoreResultInner)this.beginRestore(resourceGroupName, cloudHsmClusterName, restoreRequestProperties).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RestoreResultInner restore(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties, Context context) {
        return (RestoreResultInner)this.beginRestore(resourceGroupName, cloudHsmClusterName, restoreRequestProperties, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CloudHsmClusterInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudHsmClusterListResult)res.getValue()).value(), ((CloudHsmClusterListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CloudHsmClusterInner> listByResourceGroupNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CloudHsmClusterListResult> res = this.service.listByResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudHsmClusterListResult)res.getValue()).value(), ((CloudHsmClusterListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CloudHsmClusterInner> listByResourceGroupNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CloudHsmClusterListResult> res = this.service.listByResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudHsmClusterListResult)res.getValue()).value(), ((CloudHsmClusterListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CloudHsmClusterInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudHsmClusterListResult)res.getValue()).value(), ((CloudHsmClusterListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CloudHsmClusterInner> listBySubscriptionNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CloudHsmClusterListResult> res = this.service.listBySubscriptionNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudHsmClusterListResult)res.getValue()).value(), ((CloudHsmClusterListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CloudHsmClusterInner> listBySubscriptionNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CloudHsmClusterListResult> res = this.service.listBySubscriptionNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudHsmClusterListResult)res.getValue()).value(), ((CloudHsmClusterListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="HardwareSecurityModulesManagementClientCloudHsmClusters")
    public static interface CloudHsmClustersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CloudHsmClusterInner>> getByResourceGroup(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudHsmClusterName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CloudHsmClusterInner> getByResourceGroupSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudHsmClusterName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudHsmClusterName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") CloudHsmClusterInner var8, Context var9);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudHsmClusterName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") CloudHsmClusterInner var8, Context var9);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudHsmClusterName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") CloudHsmClusterPatchParameters var8, Context var9);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudHsmClusterName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") CloudHsmClusterPatchParameters var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudHsmClusterName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudHsmClusterName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CloudHsmClusterListResult>> listByResourceGroup(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @QueryParam(value="$skiptoken") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CloudHsmClusterListResult> listByResourceGroupSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @QueryParam(value="$skiptoken") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CloudHsmClusterListResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="$skiptoken") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CloudHsmClusterListResult> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="$skiptoken") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}/validateBackupProperties")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> validateBackupProperties(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudHsmClusterName") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BackupRequestProperties var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}/validateBackupProperties")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> validateBackupPropertiesSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudHsmClusterName") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BackupRequestProperties var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}/backup")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> backup(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudHsmClusterName") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BackupRequestProperties var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}/backup")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> backupSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudHsmClusterName") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BackupRequestProperties var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}/validateRestoreProperties")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> validateRestoreProperties(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudHsmClusterName") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") RestoreRequestProperties var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}/validateRestoreProperties")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> validateRestorePropertiesSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudHsmClusterName") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") RestoreRequestProperties var7, Context var8);

        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}/restore")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> restore(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudHsmClusterName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") RestoreRequestProperties var8, Context var9);

        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}/restore")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> restoreSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudHsmClusterName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") RestoreRequestProperties var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CloudHsmClusterListResult>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CloudHsmClusterListResult> listByResourceGroupNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CloudHsmClusterListResult>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CloudHsmClusterListResult> listBySubscriptionNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

