/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.hardwaresecuritymodules.HardwareSecurityModulesManager;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.CloudHsmClusterRestoreStatusClient;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.RestoreResultInner;
import com.azure.resourcemanager.hardwaresecuritymodules.implementation.RestoreResultImpl;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmClusterRestoreStatus;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmClusterRestoreStatusGetResponse;
import com.azure.resourcemanager.hardwaresecuritymodules.models.RestoreResult;

public final class CloudHsmClusterRestoreStatusImpl
implements CloudHsmClusterRestoreStatus {
    private static final ClientLogger LOGGER = new ClientLogger(CloudHsmClusterRestoreStatusImpl.class);
    private final CloudHsmClusterRestoreStatusClient innerClient;
    private final HardwareSecurityModulesManager serviceManager;

    public CloudHsmClusterRestoreStatusImpl(CloudHsmClusterRestoreStatusClient innerClient, HardwareSecurityModulesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<RestoreResult> getWithResponse(String resourceGroupName, String cloudHsmClusterName, String jobId, Context context) {
        CloudHsmClusterRestoreStatusGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, cloudHsmClusterName, jobId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RestoreResultImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public RestoreResult get(String resourceGroupName, String cloudHsmClusterName, String jobId) {
        RestoreResultInner inner = this.serviceClient().get(resourceGroupName, cloudHsmClusterName, jobId);
        if (inner != null) {
            return new RestoreResultImpl(inner, this.manager());
        }
        return null;
    }

    private CloudHsmClusterRestoreStatusClient serviceClient() {
        return this.innerClient;
    }

    private HardwareSecurityModulesManager manager() {
        return this.serviceManager;
    }
}

