/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.hardwaresecuritymodules.models.DedicatedHsmProperties;
import com.azure.resourcemanager.hardwaresecuritymodules.models.Sku;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DedicatedHsmInner
extends Resource {
    private Sku sku;
    private List<String> zones;
    private DedicatedHsmProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(DedicatedHsmInner.class);

    public Sku sku() {
        return this.sku;
    }

    public DedicatedHsmInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public DedicatedHsmInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public DedicatedHsmProperties properties() {
        return this.properties;
    }

    public DedicatedHsmInner withProperties(DedicatedHsmProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public DedicatedHsmInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DedicatedHsmInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model DedicatedHsmInner"));
        }
        this.sku().validate();
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model DedicatedHsmInner"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DedicatedHsmInner fromJson(JsonReader jsonReader) throws IOException {
        return (DedicatedHsmInner)((Object)jsonReader.readObject(reader -> {
            DedicatedHsmInner deserializedDedicatedHsmInner = new DedicatedHsmInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDedicatedHsmInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDedicatedHsmInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDedicatedHsmInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDedicatedHsmInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDedicatedHsmInner.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedDedicatedHsmInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDedicatedHsmInner.properties = DedicatedHsmProperties.fromJson(reader);
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedDedicatedHsmInner.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDedicatedHsmInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDedicatedHsmInner;
        }));
    }
}

