/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.fluent.models.ApplicationGroupProperties;
import com.azure.resourcemanager.eventhubs.models.ApplicationGroupPolicy;
import java.io.IOException;
import java.util.List;

public final class ApplicationGroupInner
extends ProxyResource {
    private ApplicationGroupProperties innerProperties;
    private SystemData systemData;
    private String location;
    private String id;
    private String name;
    private String type;

    private ApplicationGroupProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String location() {
        return this.location;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public Boolean isEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isEnabled();
    }

    public ApplicationGroupInner withIsEnabled(Boolean isEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGroupProperties();
        }
        this.innerProperties().withIsEnabled(isEnabled);
        return this;
    }

    public String clientAppGroupIdentifier() {
        return this.innerProperties() == null ? null : this.innerProperties().clientAppGroupIdentifier();
    }

    public ApplicationGroupInner withClientAppGroupIdentifier(String clientAppGroupIdentifier) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGroupProperties();
        }
        this.innerProperties().withClientAppGroupIdentifier(clientAppGroupIdentifier);
        return this;
    }

    public List<ApplicationGroupPolicy> policies() {
        return this.innerProperties() == null ? null : this.innerProperties().policies();
    }

    public ApplicationGroupInner withPolicies(List<ApplicationGroupPolicy> policies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGroupProperties();
        }
        this.innerProperties().withPolicies(policies);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGroupInner)((Object)jsonReader.readObject(reader -> {
            ApplicationGroupInner deserializedApplicationGroupInner = new ApplicationGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedApplicationGroupInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedApplicationGroupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApplicationGroupInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedApplicationGroupInner.innerProperties = ApplicationGroupProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedApplicationGroupInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedApplicationGroupInner.location = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGroupInner;
        }));
    }
}

