/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.WebhookPartnerDestinationProperties;
import com.azure.resourcemanager.eventgrid.models.PartnerClientAuthentication;
import com.azure.resourcemanager.eventgrid.models.PartnerEndpointType;
import com.azure.resourcemanager.eventgrid.models.PartnerUpdateDestinationInfo;
import java.io.IOException;

public final class WebhookUpdatePartnerDestinationInfo
extends PartnerUpdateDestinationInfo {
    private PartnerEndpointType endpointType = PartnerEndpointType.WEB_HOOK;
    private WebhookPartnerDestinationProperties innerProperties;

    @Override
    public PartnerEndpointType endpointType() {
        return this.endpointType;
    }

    WebhookPartnerDestinationProperties innerProperties() {
        return this.innerProperties;
    }

    public String endpointUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointUrl();
    }

    public WebhookUpdatePartnerDestinationInfo withEndpointUrl(String endpointUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookPartnerDestinationProperties();
        }
        this.innerProperties().withEndpointUrl(endpointUrl);
        return this;
    }

    public String endpointBaseUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointBaseUrl();
    }

    public WebhookUpdatePartnerDestinationInfo withEndpointBaseUrl(String endpointBaseUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookPartnerDestinationProperties();
        }
        this.innerProperties().withEndpointBaseUrl(endpointBaseUrl);
        return this;
    }

    public PartnerClientAuthentication clientAuthentication() {
        return this.innerProperties() == null ? null : this.innerProperties().clientAuthentication();
    }

    public WebhookUpdatePartnerDestinationInfo withClientAuthentication(PartnerClientAuthentication clientAuthentication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookPartnerDestinationProperties();
        }
        this.innerProperties().withClientAuthentication(clientAuthentication);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpointType", this.endpointType == null ? null : this.endpointType.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WebhookUpdatePartnerDestinationInfo fromJson(JsonReader jsonReader) throws IOException {
        return (WebhookUpdatePartnerDestinationInfo)jsonReader.readObject(reader -> {
            WebhookUpdatePartnerDestinationInfo deserializedWebhookUpdatePartnerDestinationInfo = new WebhookUpdatePartnerDestinationInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpointType".equals(fieldName)) {
                    deserializedWebhookUpdatePartnerDestinationInfo.endpointType = PartnerEndpointType.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWebhookUpdatePartnerDestinationInfo.innerProperties = WebhookPartnerDestinationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebhookUpdatePartnerDestinationInfo;
        });
    }
}

