/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.WebhookPartnerDestinationProperties;
import com.azure.resourcemanager.eventgrid.models.PartnerClientAuthentication;
import com.azure.resourcemanager.eventgrid.models.PartnerDestinationInfo;
import com.azure.resourcemanager.eventgrid.models.PartnerEndpointType;
import com.azure.resourcemanager.eventgrid.models.ResourceMoveChangeHistory;
import java.io.IOException;
import java.util.List;

public final class WebhookPartnerDestinationInfo
extends PartnerDestinationInfo {
    private PartnerEndpointType endpointType = PartnerEndpointType.WEB_HOOK;
    private WebhookPartnerDestinationProperties innerProperties;

    @Override
    public PartnerEndpointType endpointType() {
        return this.endpointType;
    }

    WebhookPartnerDestinationProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public WebhookPartnerDestinationInfo withAzureSubscriptionId(String azureSubscriptionId) {
        super.withAzureSubscriptionId(azureSubscriptionId);
        return this;
    }

    @Override
    public WebhookPartnerDestinationInfo withResourceGroupName(String resourceGroupName) {
        super.withResourceGroupName(resourceGroupName);
        return this;
    }

    @Override
    public WebhookPartnerDestinationInfo withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public WebhookPartnerDestinationInfo withEndpointServiceContext(String endpointServiceContext) {
        super.withEndpointServiceContext(endpointServiceContext);
        return this;
    }

    @Override
    public WebhookPartnerDestinationInfo withResourceMoveChangeHistory(List<ResourceMoveChangeHistory> resourceMoveChangeHistory) {
        super.withResourceMoveChangeHistory(resourceMoveChangeHistory);
        return this;
    }

    public String endpointUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointUrl();
    }

    public WebhookPartnerDestinationInfo withEndpointUrl(String endpointUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookPartnerDestinationProperties();
        }
        this.innerProperties().withEndpointUrl(endpointUrl);
        return this;
    }

    public String endpointBaseUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointBaseUrl();
    }

    public WebhookPartnerDestinationInfo withEndpointBaseUrl(String endpointBaseUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookPartnerDestinationProperties();
        }
        this.innerProperties().withEndpointBaseUrl(endpointBaseUrl);
        return this;
    }

    public PartnerClientAuthentication clientAuthentication() {
        return this.innerProperties() == null ? null : this.innerProperties().clientAuthentication();
    }

    public WebhookPartnerDestinationInfo withClientAuthentication(PartnerClientAuthentication clientAuthentication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookPartnerDestinationProperties();
        }
        this.innerProperties().withClientAuthentication(clientAuthentication);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.resourceMoveChangeHistory() != null) {
            this.resourceMoveChangeHistory().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("azureSubscriptionId", this.azureSubscriptionId());
        jsonWriter.writeStringField("resourceGroupName", this.resourceGroupName());
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("endpointServiceContext", this.endpointServiceContext());
        jsonWriter.writeArrayField("resourceMoveChangeHistory", this.resourceMoveChangeHistory(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("endpointType", this.endpointType == null ? null : this.endpointType.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WebhookPartnerDestinationInfo fromJson(JsonReader jsonReader) throws IOException {
        return (WebhookPartnerDestinationInfo)jsonReader.readObject(reader -> {
            WebhookPartnerDestinationInfo deserializedWebhookPartnerDestinationInfo = new WebhookPartnerDestinationInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("azureSubscriptionId".equals(fieldName)) {
                    deserializedWebhookPartnerDestinationInfo.withAzureSubscriptionId(reader.getString());
                    continue;
                }
                if ("resourceGroupName".equals(fieldName)) {
                    deserializedWebhookPartnerDestinationInfo.withResourceGroupName(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWebhookPartnerDestinationInfo.withName(reader.getString());
                    continue;
                }
                if ("endpointServiceContext".equals(fieldName)) {
                    deserializedWebhookPartnerDestinationInfo.withEndpointServiceContext(reader.getString());
                    continue;
                }
                if ("resourceMoveChangeHistory".equals(fieldName)) {
                    List resourceMoveChangeHistory = reader.readArray(reader1 -> ResourceMoveChangeHistory.fromJson(reader1));
                    deserializedWebhookPartnerDestinationInfo.withResourceMoveChangeHistory(resourceMoveChangeHistory);
                    continue;
                }
                if ("endpointType".equals(fieldName)) {
                    deserializedWebhookPartnerDestinationInfo.endpointType = PartnerEndpointType.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWebhookPartnerDestinationInfo.innerProperties = WebhookPartnerDestinationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebhookPartnerDestinationInfo;
        });
    }
}

