/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.CustomWebhookAuthenticationManagedIdentity;
import java.io.IOException;

public final class WebhookAuthenticationSettings
implements JsonSerializable<WebhookAuthenticationSettings> {
    private CustomWebhookAuthenticationManagedIdentity identity;
    private String endpointUrl;
    private String endpointBaseUrl;
    private String azureActiveDirectoryApplicationIdOrUri;
    private String azureActiveDirectoryTenantId;
    private static final ClientLogger LOGGER = new ClientLogger(WebhookAuthenticationSettings.class);

    public CustomWebhookAuthenticationManagedIdentity identity() {
        return this.identity;
    }

    public WebhookAuthenticationSettings withIdentity(CustomWebhookAuthenticationManagedIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String endpointUrl() {
        return this.endpointUrl;
    }

    public WebhookAuthenticationSettings withEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
        return this;
    }

    public String endpointBaseUrl() {
        return this.endpointBaseUrl;
    }

    public WebhookAuthenticationSettings withEndpointBaseUrl(String endpointBaseUrl) {
        this.endpointBaseUrl = endpointBaseUrl;
        return this;
    }

    public String azureActiveDirectoryApplicationIdOrUri() {
        return this.azureActiveDirectoryApplicationIdOrUri;
    }

    public WebhookAuthenticationSettings withAzureActiveDirectoryApplicationIdOrUri(String azureActiveDirectoryApplicationIdOrUri) {
        this.azureActiveDirectoryApplicationIdOrUri = azureActiveDirectoryApplicationIdOrUri;
        return this;
    }

    public String azureActiveDirectoryTenantId() {
        return this.azureActiveDirectoryTenantId;
    }

    public WebhookAuthenticationSettings withAzureActiveDirectoryTenantId(String azureActiveDirectoryTenantId) {
        this.azureActiveDirectoryTenantId = azureActiveDirectoryTenantId;
        return this;
    }

    public void validate() {
        if (this.identity() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property identity in model WebhookAuthenticationSettings"));
        }
        this.identity().validate();
        if (this.endpointUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endpointUrl in model WebhookAuthenticationSettings"));
        }
        if (this.azureActiveDirectoryApplicationIdOrUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property azureActiveDirectoryApplicationIdOrUri in model WebhookAuthenticationSettings"));
        }
        if (this.azureActiveDirectoryTenantId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property azureActiveDirectoryTenantId in model WebhookAuthenticationSettings"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("endpointUrl", this.endpointUrl);
        jsonWriter.writeStringField("azureActiveDirectoryApplicationIdOrUri", this.azureActiveDirectoryApplicationIdOrUri);
        jsonWriter.writeStringField("azureActiveDirectoryTenantId", this.azureActiveDirectoryTenantId);
        jsonWriter.writeStringField("endpointBaseUrl", this.endpointBaseUrl);
        return jsonWriter.writeEndObject();
    }

    public static WebhookAuthenticationSettings fromJson(JsonReader jsonReader) throws IOException {
        return (WebhookAuthenticationSettings)jsonReader.readObject(reader -> {
            WebhookAuthenticationSettings deserializedWebhookAuthenticationSettings = new WebhookAuthenticationSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identity".equals(fieldName)) {
                    deserializedWebhookAuthenticationSettings.identity = CustomWebhookAuthenticationManagedIdentity.fromJson(reader);
                    continue;
                }
                if ("endpointUrl".equals(fieldName)) {
                    deserializedWebhookAuthenticationSettings.endpointUrl = reader.getString();
                    continue;
                }
                if ("azureActiveDirectoryApplicationIdOrUri".equals(fieldName)) {
                    deserializedWebhookAuthenticationSettings.azureActiveDirectoryApplicationIdOrUri = reader.getString();
                    continue;
                }
                if ("azureActiveDirectoryTenantId".equals(fieldName)) {
                    deserializedWebhookAuthenticationSettings.azureActiveDirectoryTenantId = reader.getString();
                    continue;
                }
                if ("endpointBaseUrl".equals(fieldName)) {
                    deserializedWebhookAuthenticationSettings.endpointBaseUrl = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebhookAuthenticationSettings;
        });
    }
}

