/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicUpdateParameterProperties;
import com.azure.resourcemanager.eventgrid.models.DataResidencyBoundary;
import com.azure.resourcemanager.eventgrid.models.EventTypeInfo;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.ResourceSku;
import com.azure.resourcemanager.eventgrid.models.TlsVersion;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class TopicUpdateParameters
implements JsonSerializable<TopicUpdateParameters> {
    private Map<String, String> tags;
    private IdentityInfo identity;
    private TopicUpdateParameterProperties innerProperties;
    private ResourceSku sku;

    public Map<String, String> tags() {
        return this.tags;
    }

    public TopicUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public IdentityInfo identity() {
        return this.identity;
    }

    public TopicUpdateParameters withIdentity(IdentityInfo identity) {
        this.identity = identity;
        return this;
    }

    private TopicUpdateParameterProperties innerProperties() {
        return this.innerProperties;
    }

    public ResourceSku sku() {
        return this.sku;
    }

    public TopicUpdateParameters withSku(ResourceSku sku) {
        this.sku = sku;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public TopicUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicUpdateParameterProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public List<InboundIpRule> inboundIpRules() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundIpRules();
    }

    public TopicUpdateParameters withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicUpdateParameterProperties();
        }
        this.innerProperties().withInboundIpRules(inboundIpRules);
        return this;
    }

    public TlsVersion minimumTlsVersionAllowed() {
        return this.innerProperties() == null ? null : this.innerProperties().minimumTlsVersionAllowed();
    }

    public TopicUpdateParameters withMinimumTlsVersionAllowed(TlsVersion minimumTlsVersionAllowed) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicUpdateParameterProperties();
        }
        this.innerProperties().withMinimumTlsVersionAllowed(minimumTlsVersionAllowed);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public TopicUpdateParameters withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicUpdateParameterProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public DataResidencyBoundary dataResidencyBoundary() {
        return this.innerProperties() == null ? null : this.innerProperties().dataResidencyBoundary();
    }

    public TopicUpdateParameters withDataResidencyBoundary(DataResidencyBoundary dataResidencyBoundary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicUpdateParameterProperties();
        }
        this.innerProperties().withDataResidencyBoundary(dataResidencyBoundary);
        return this;
    }

    public EventTypeInfo eventTypeInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().eventTypeInfo();
    }

    public TopicUpdateParameters withEventTypeInfo(EventTypeInfo eventTypeInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicUpdateParameterProperties();
        }
        this.innerProperties().withEventTypeInfo(eventTypeInfo);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        return jsonWriter.writeEndObject();
    }

    public static TopicUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (TopicUpdateParameters)jsonReader.readObject(reader -> {
            TopicUpdateParameters deserializedTopicUpdateParameters = new TopicUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedTopicUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedTopicUpdateParameters.identity = IdentityInfo.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedTopicUpdateParameters.innerProperties = TopicUpdateParameterProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedTopicUpdateParameters.sku = ResourceSku.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTopicUpdateParameters;
        });
    }
}

